/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionPage
extends WizardPage {
    private final BindProjectWizard wizard;
    private SearchPattern pattern = new SearchPattern(35);
    private final CodewindConnection connection;
    private Button workspaceProject;
    private Text filterText;
    private CheckboxTableViewer projectList;
    private Text noProjectsText;
    private Button fileSystemProject;
    private Text pathText;
    private IProject project = null;
    private String projectPath = null;
    private boolean hasValidProjects = false;

    protected ProjectSelectionPage(BindProjectWizard wizard, CodewindConnection connection) {
        super(Messages.SelectProjectPageName);
        this.setTitle(Messages.SelectProjectPageTitle);
        this.setDescription(Messages.SelectProjectPageDescription);
        this.pattern.setPattern("*");
        this.wizard = wizard;
        this.connection = connection;
        this.hasValidProjects = this.hasValidProjects();
    }

    public void createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.workspaceProject = new Button(composite, 16);
        this.workspaceProject.setText(Messages.SelectProjectPageWorkspaceProject);
        this.workspaceProject.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        if (this.hasValidProjects) {
            this.filterText = new Text(composite, 2048);
            data = new GridData(4, 0x1000000, true, false, 3, 1);
            data.horizontalIndent = 20;
            this.filterText.setLayoutData((Object)data);
            this.filterText.setMessage(Messages.SelectProjectPageFilterText);
            this.projectList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
            this.projectList.setContentProvider((IContentProvider)new WorkbenchContentProvider());
            this.projectList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.projectList.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            data = new GridData(4, 4, true, true, 3, 1);
            data.heightHint = 160;
            data.horizontalIndent = 20;
            this.projectList.getTable().setLayoutData((Object)data);
            this.projectList.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElem, Object elem) {
                    if (!(elem instanceof IProject)) {
                        return false;
                    }
                    return ProjectSelectionPage.this.isValidProject((IProject)elem);
                }
            });
            this.workspaceProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectSelectionPage.this.filterText.setEnabled(ProjectSelectionPage.this.workspaceProject.getSelection());
                    ProjectSelectionPage.this.projectList.getTable().setEnabled(ProjectSelectionPage.this.workspaceProject.getSelection());
                    ProjectSelectionPage.this.validate();
                }
            });
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String filter = ProjectSelectionPage.this.filterText.getText();
                    if (filter == null || filter.isEmpty()) {
                        ProjectSelectionPage.this.filterText.setMessage(Messages.SelectProjectPageFilterText);
                        ProjectSelectionPage.this.pattern.setPattern("*");
                    } else {
                        ProjectSelectionPage.this.pattern.setPattern("*" + filter + "*");
                    }
                    ProjectSelectionPage.this.projectList.refresh();
                }
            });
            this.projectList.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        ProjectSelectionPage.this.projectList.setCheckedElements(new Object[]{event.getElement()});
                    }
                    ProjectSelectionPage.this.validate();
                }
            });
        } else {
            this.noProjectsText = new Text(composite, 72);
            this.noProjectsText.setText(Messages.SelectProjectPageNoWorkspaceProjects);
            data = new GridData(4, 0x1000000, true, false, 3, 1);
            data.horizontalIndent = 20;
            data.widthHint = 150;
            this.noProjectsText.setLayoutData((Object)data);
            IDEUtil.normalizeBackground((Control)this.noProjectsText, (Control)composite);
        }
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.fileSystemProject = new Button(composite, 16);
        this.fileSystemProject.setText(Messages.SelectProjectPageFilesystemProject);
        this.fileSystemProject.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        final Label pathLabel = new Label(composite, 0);
        pathLabel.setText(Messages.SelectProjectPagePathLabel);
        data = new GridData(4, 0x1000000, false, false, 1, 1);
        data.horizontalIndent = 20;
        pathLabel.setLayoutData((Object)data);
        this.pathText = new Text(composite, 2048);
        data = new GridData(4, 0x1000000, true, false, 1, 1);
        data.horizontalIndent = 20;
        this.pathText.setLayoutData((Object)data);
        final Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.SelectProjectPageBrowseButton);
        data = new GridData(4, 0x1000000, false, false, 1, 1);
        data.horizontalIndent = 20;
        browseButton.setData((Object)data);
        this.fileSystemProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pathLabel.setEnabled(ProjectSelectionPage.this.fileSystemProject.getSelection());
                ProjectSelectionPage.this.pathText.setEnabled(ProjectSelectionPage.this.fileSystemProject.getSelection());
                browseButton.setEnabled(ProjectSelectionPage.this.fileSystemProject.getSelection());
                ProjectSelectionPage.this.validate();
            }
        });
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ProjectSelectionPage.this.validate();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                dialog.setMessage(Messages.SelectProjectPageFilesystemDialogTitle);
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.trim().isEmpty()) {
                    ProjectSelectionPage.this.pathText.setText(selectedDirectory.trim());
                }
                ProjectSelectionPage.this.validate();
            }
        });
        if (this.hasValidProjects) {
            this.workspaceProject.setSelection(true);
            this.fileSystemProject.setSelection(false);
            this.filterText.setFocus();
        } else {
            this.fileSystemProject.setSelection(true);
            this.workspaceProject.setSelection(false);
            this.workspaceProject.setEnabled(false);
            this.noProjectsText.setEnabled(false);
            this.pathText.setFocus();
        }
        if (this.hasValidProjects) {
            this.filterText.setEnabled(this.workspaceProject.getSelection());
            this.projectList.getTable().setEnabled(this.workspaceProject.getSelection());
        }
        pathLabel.setEnabled(this.fileSystemProject.getSelection());
        this.pathText.setEnabled(this.fileSystemProject.getSelection());
        browseButton.setEnabled(this.fileSystemProject.getSelection());
        if (this.hasValidProjects && this.workspaceProject.getSelection() && this.projectList.getTable().getItemCount() == 1) {
            this.projectList.setChecked(this.projectList.getElementAt(0), true);
        }
        this.validate();
        this.setControl((Control)composite);
    }

    private boolean hasValidProjects() {
        IProject[] projects;
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!this.isValidProject(project)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidProject(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        if (!this.pattern.matches(project.getName())) {
            return false;
        }
        return this.connection.getAppByName(project.getName()) == null;
    }

    private void validate() {
        String errorMsg = null;
        if (this.workspaceProject.getSelection()) {
            if (this.hasValidProjects) {
                Object[] checked = this.projectList.getCheckedElements();
                this.project = checked.length == 1 ? (IProject)checked[0] : null;
                this.projectPath = null;
            }
        } else {
            String text = this.pathText.getText();
            this.projectPath = text != null && !text.trim().isEmpty() ? text.trim() : null;
            this.project = null;
            if (this.projectPath != null) {
                Path path = new Path(this.projectPath);
                if (!path.toFile().exists()) {
                    errorMsg = Messages.SelectProjectPageNoExistError;
                    this.projectPath = null;
                } else if (this.connection.getAppByName(path.lastSegment()) != null) {
                    errorMsg = NLS.bind((String)Messages.SelectProjectPageCWProjectExistsError, (Object)path.lastSegment());
                    this.projectPath = null;
                } else {
                    IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                    if (existingProject.exists() && !path.toFile().equals(existingProject.getLocation().toFile())) {
                        errorMsg = NLS.bind((String)Messages.SelectProjectPageProjectExistsError, (Object)path.lastSegment());
                        this.projectPath = null;
                    }
                }
            }
        }
        this.setErrorMessage(errorMsg);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    public IWizardPage getNextPage() {
        this.wizard.setProjectPath(this.getProjectPath());
        return super.getNextPage();
    }

    public boolean canFinish() {
        return this.project != null || this.projectPath != null;
    }

    public IPath getProjectPath() {
        if (this.project != null) {
            return this.project.getLocation();
        }
        if (this.projectPath != null) {
            return new Path(this.projectPath);
        }
        return null;
    }
}

