"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const log = require("./Logger");
/**
 * Every X minutes, this timer will run and output the internal state of
 * each of the internal components of the filewatcher. This should run
 * infrequently, as it can be fairly verbose (eg every 30 minutes).
 *
 * The goal of this timer is to identify bugs/performance issues that might only
 * be detectable when the filewatcher is running for long periods of time (memory
 * leaks, resources we aren't closing, etc).
 */
class DebugTimer {
    constructor(parent) {
        this._parent = parent;
        const debugTimer = this;
        this.schedule();
    }
    tick() {
        let renew = true;
        try {
            const debugStr = this._parent.generateDebugString();
            if (!debugStr || debugStr.trim().length === 0) {
                // Filewatcher is disposed.
                renew = false;
                return;
            }
            for (const str of debugStr.split("\n")) {
                log.info("[status] " + str);
            }
        }
        finally {
            if (renew) {
                this.schedule();
            }
        }
    }
    schedule() {
        const debugTimer = this;
        this._timer = setTimeout(() => {
            debugTimer.tick();
        }, 30 * 60 * 1000);
    }
}
exports.DebugTimer = DebugTimer;
