/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.component.component.CommandEvent;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.CommandReplyWithVars;
import org.eclipse.comma.behavior.component.component.EventCall;
import org.eclipse.comma.behavior.component.component.EventWithVars;
import org.eclipse.comma.behavior.component.component.NotificationEvent;
import org.eclipse.comma.behavior.component.component.PortSelector;
import org.eclipse.comma.behavior.component.component.SignalEvent;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.TriggeredTransition;
import org.eclipse.comma.behavior.component.component.impl.CommandEventImpl;
import org.eclipse.comma.behavior.component.component.impl.CommandReplyImpl;
import org.eclipse.comma.behavior.component.component.impl.NotificationEventImpl;
import org.eclipse.comma.behavior.component.component.impl.SignalEventImpl;
import org.eclipse.comma.behavior.component.utilities.ClauseFragments;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.component.utilities.FunctionFragment;
import org.eclipse.comma.behavior.component.utilities.FunctionFragmentCall;
import org.eclipse.comma.behavior.component.utilities.IfHelperAction;
import org.eclipse.comma.behavior.component.utilities.StateTransitionAction;
import org.eclipse.comma.behavior.component.utilities.TransitionDecomposer;
import org.eclipse.comma.behavior.component.utilities.TransitionFragment;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.petrinet.PythonConstraintConverter;
import org.eclipse.comma.petrinet.PythonHelper;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.impl.SignalImpl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class PythonSBFCConverter
extends PythonConstraintConverter {
    private static StateTransitionAction stateTrans;
    private static List<String> functions;

    static {
        functions = new ArrayList<String>();
    }

    public static String convert(StateBasedFunctionalConstraint constraint) {
        StringBuilder sb = new StringBuilder();
        String className = String.valueOf(constraint.getName()) + "Constraint";
        functions = new ArrayList<String>();
        sb.append("@dataclass\n");
        sb.append("class " + className + ":\n");
        State initial = constraint.getStates().stream().filter(s -> s.isInitial()).findFirst().get();
        sb.append("    states: List[ConstraintState]\n\n");
        sb.append("    use_event = [\n");
        for (EventPattern event : constraint.getUsedEvents()) {
            sb.append("        " + PythonSBFCConverter.convertEventPattern(event, new ArrayList<Expression>()) + ",\n");
        }
        sb.append("    ]\n\n");
        sb.append("    def __init__(self, states=None, init=True):\n");
        sb.append("        if init:\n");
        sb.append("            v = Variables({})\n");
        for (Variable variable : constraint.getVars()) {
            Type type = variable.getType();
            String varName = String.format("%s%s", "v.", variable.getName());
            if (type instanceof TypeReference) {
                sb.append(String.format("%s%s = %s\n", "            ", varName, PythonHelper.defaultValue((TypeObject)variable.getType().getType())));
                continue;
            }
            sb.append(String.format("%s%s = %s\n", "            ", varName, PythonHelper.defaultValue((TypeObject)variable.getType())));
        }
        for (Action action : constraint.getInitActions()) {
            sb.append(String.format("%s%s\n", "            ", PythonHelper.action(action, v -> "v.", true, false)));
        }
        sb.append("            " + String.format("initState = [ConstraintState('%s', None, v)]\n", initial.getName()));
        sb.append("            self.states = initState\n");
        sb.append("        else:\n");
        sb.append("            self.states = states\n");
        sb.append("\n");
        sb.append("    def __str__(self) -> str:\n");
        sb.append("        return f\"{__class__.__name__} {self.states}\"\n\n");
        sb.append("    def take(self, event: Event, port_machine_state: Dict[str, Dict[str, str]]):\n");
        sb.append("        if len([e for e in self.use_event if e.equals(event, True)]) == 0:\n");
        sb.append("            return self\n\n");
        sb.append("        states = []\n");
        sb.append("        for cstate in self.states:\n");
        sb.append("            index = cstate.index\n");
        sb.append("            s = cstate.state\n");
        sb.append("            v = cstate.variables\n");
        for (State state : constraint.getStates()) {
            sb.append("            if s == '" + state.getName() + "':\n");
            for (Transition transition : state.getTransitions()) {
                int transitionIndex = state.getTransitions().indexOf((Object)transition);
                sb.append("                # Transition " + transitionIndex + "\n");
                boolean firstClause = true;
                for (Clause clause : transition.getClauses()) {
                    ClauseFragments fragments = TransitionDecomposer.decomposeTransition((StateBasedFunctionalConstraint)constraint, (Transition)transition, (Clause)clause);
                    stateTrans = null;
                    Transition rootTransition = fragments.getRootFragment().getTransition();
                    if (rootTransition instanceof TriggeredTransition) {
                        if (firstClause) {
                            sb.append(PythonSBFCConverter.convertFragments(fragments, className, clause, state, transitionIndex, true));
                            firstClause = false;
                            continue;
                        }
                        sb.append(PythonSBFCConverter.convertFragments(fragments, className, clause, state, transitionIndex, false));
                        continue;
                    }
                    if (!(rootTransition instanceof NonTriggeredTransition)) continue;
                    for (Clause subClause : rootTransition.getClauses()) {
                        ClauseFragments subFragments = TransitionDecomposer.decomposeTransition((StateBasedFunctionalConstraint)constraint, (Transition)rootTransition, (Clause)subClause);
                        sb.append(PythonSBFCConverter.convertFragments(subFragments, className, clause, state, transitionIndex, true));
                    }
                }
            }
            if (!state.getTransitions().isEmpty()) continue;
            sb.append("                pass\n");
        }
        sb.append("        if len(states):\n");
        sb.append(String.format("%sreturn %s(states, False)\n", "            ", className));
        sb.append("\n        return None\n\n");
        int i = 0;
        while (i < functions.size()) {
            sb.append("    def function_" + i + "(self, v):\n");
            sb.append(String.valueOf(functions.get(i)) + "\n");
            ++i;
        }
        sb.append("    def get_state(self) -> List[ConstraintState]:\n");
        sb.append("        return self.states\n\n");
        sb.append("    def set_state(self, state: List[ConstraintState]):\n");
        sb.append("        self.states = state\n");
        return sb.toString();
    }

    private static String convertFragments(ClauseFragments cf, String className, Clause clause, State state, int transitionIndex, boolean firstClause) {
        StringBuilder sb = new StringBuilder();
        int actionIndex = 1;
        cf.getRootFragment().setMethodName("None");
        for (TransitionFragment trans : cf.getSubTransitionFragments()) {
            trans.setMethodName("(" + transitionIndex + "," + actionIndex + ")");
            ++actionIndex;
        }
        if (firstClause && cf.getRootFragment().getTransition() instanceof TriggeredTransition) {
            sb.append(PythonSBFCConverter.convertTransition(cf.getRootFragment(), className, state));
            firstClause = false;
        }
        if (firstClause) {
            for (TransitionFragment subTrans : cf.getSubTransitionFragments()) {
                sb.append(PythonSBFCConverter.convertActions(subTrans.getActions(), className, state, "None", "                    "));
            }
        } else {
            for (TransitionFragment subTrans : cf.getSubTransitionFragments()) {
                sb.append(PythonSBFCConverter.convertActions(subTrans.getActions(), className, state, subTrans.getMethodName(), "                    "));
            }
        }
        return sb.toString();
    }

    private static String convertStateTransition(Object action, String className, State state, String indent) {
        StringBuilder sb = new StringBuilder();
        if (action instanceof StateTransitionAction) {
            boolean isLastAction = false;
            StateTransitionAction stateAction = (StateTransitionAction)action;
            String nextState = stateAction.getNextState();
            String nextIndex = "";
            nextIndex = stateAction.getTransitionFragment() != null ? stateAction.getTransitionFragment().getMethodName() : "None";
            if (nextState != "") {
                isLastAction = true;
            }
            if (isLastAction) {
                sb.append(String.format("%sstates.append(%s('%s', %s, v))\n", indent, "ConstraintState", nextState, "None"));
            } else {
                sb.append(String.format("%sstates.append(%s('%s', %s, v))\n", indent, "ConstraintState", state.getName(), nextIndex));
            }
        }
        return sb.toString();
    }

    private static String convertIfAction(Object action, String className, State state, String nextState, String index, String indent) {
        StringBuilder sb = new StringBuilder();
        if (action instanceof IfHelperAction) {
            IfHelperAction ifaction = (IfHelperAction)action;
            Expression condition = ifaction.getCondition();
            sb.append(String.format("%sif %s:\n", indent, PythonHelper.expression(condition, v -> "v.", e -> PythonSBFCConverter.handleUnsupportedExpression(e))));
            if (ifaction.getThenActions() != null) {
                sb.append(PythonSBFCConverter.convertActions(ifaction.getThenActions(), className, state, index, String.valueOf(indent) + "    "));
            }
            if (ifaction.getElseActions() != null) {
                sb.append(String.format("%selse:\n", indent));
                sb.append(PythonSBFCConverter.convertActions(ifaction.getElseActions(), className, state, index, String.valueOf(indent) + "    "));
            }
        } else if (action instanceof IfAction) {
            ArrayList<Object> actions;
            IfAction ifaction = (IfAction)action;
            Expression condition = ifaction.getGuard();
            sb.append(String.format("%sif %s:\n", indent, PythonHelper.expression(condition, v -> "v.", e -> PythonSBFCConverter.handleUnsupportedExpression(e))));
            if (ifaction.getThenList() != null) {
                actions = new ArrayList<Object>((Collection<Object>)ifaction.getThenList().getActions());
                sb.append(PythonSBFCConverter.convertActions(actions, className, state, index, String.valueOf(indent) + "    "));
            }
            if (ifaction.getElseList() != null) {
                sb.append(String.format("%selse:\n", indent));
                actions = new ArrayList(ifaction.getElseList().getActions());
                sb.append(PythonSBFCConverter.convertActions(actions, className, state, index, String.valueOf(indent) + "    "));
            }
        }
        return sb.toString();
    }

    private static String convertTransition(TransitionFragment tf, String className, State state) {
        StringBuilder sb = new StringBuilder();
        Transition transition = tf.getTransition();
        if (transition instanceof TriggeredTransition) {
            TriggeredTransition triggertran = (TriggeredTransition)transition;
            EventPattern eventPattern = ComponentUtilities.makeEvent((InterfaceEvent)triggertran.getTrigger(), (Command)triggertran.getReplyTo(), (PortSelector)triggertran, new ArrayList());
            List<Expression> patternParameters = PythonSBFCConverter.getEventPatternParameters(eventPattern);
            Object patternVariables = new ArrayList();
            Expression condition = null;
            Variable idVarDef = null;
            patternVariables = triggertran.getTrigger() != null ? PythonSBFCConverter.getTriggeredTransitionParameters((TriggeredTransition)transition).stream().map(p -> {
                int idx = PythonSBFCConverter.getTriggeredTransitionParameters((TriggeredTransition)transition).indexOf(p);
                Variable parameter = (Variable)triggertran.getParameters().get(idx);
                return parameter;
            }).collect(Collectors.toList()) : triggertran.getParameters();
            condition = transition.getGuard();
            idVarDef = ((TriggeredTransition)transition).getIdVarDef();
            sb.append(PythonSBFCConverter.convertEventAction(eventPattern, patternParameters, (List<Variable>)patternVariables, condition, className, "None"));
            sb.append(PythonSBFCConverter.convertActions(tf.getActions(), className, state, tf.getMethodName(), condition != null ? "                        " : "                    "));
            if (idVarDef != null) {
                throw new RuntimeException("Connection variables not supported");
            }
        }
        return sb.toString();
    }

    private static String convertAssignment(Object action, String indent) {
        StringBuilder sb = new StringBuilder();
        if (action instanceof AssignmentAction) {
            String assignment = String.format("%s%s\n", indent, PythonHelper.action((Action)((AssignmentAction)action), v -> "v.", true, false));
            sb.append(assignment);
        } else if (action instanceof RecordFieldAssignmentAction) {
            String assignment = String.format("%s%s\n", indent, PythonHelper.action((Action)((RecordFieldAssignmentAction)action), v -> "v.", true, false));
            sb.append(assignment);
        }
        return sb.toString();
    }

    private static String convertActions(List<Object> actions, String className, State state, String index, String indent) {
        StringBuilder sb = new StringBuilder();
        String reply = "";
        ArrayList<String> assignments = new ArrayList<String>();
        String nextState = state.getName();
        Expression condition = null;
        ArrayList<String> functionCallString = new ArrayList<String>();
        ArrayList<StateTransitionAction> states = new ArrayList<StateTransitionAction>();
        boolean extraFrontIndent = false;
        for (Object action : actions) {
            String assignment;
            InterfaceEvent event;
            EventPattern eventPattern;
            EList patternParameters = new ArrayList();
            Object patternVariables = new ArrayList();
            Variable idVarDef = null;
            ExpressionVariable idVar = null;
            if (action instanceof TriggeredTransition) {
                TriggeredTransition transition = (TriggeredTransition)action;
                eventPattern = ComponentUtilities.makeEvent((InterfaceEvent)transition.getTrigger(), (Command)transition.getReplyTo(), (PortSelector)transition, new ArrayList());
                patternParameters = PythonSBFCConverter.getEventPatternParameters(eventPattern);
                patternVariables = PythonSBFCConverter.getTriggeredTransitionParameters(transition).stream().map(p -> {
                    int idx = PythonSBFCConverter.getTriggeredTransitionParameters(transition).indexOf(p);
                    Variable parameter = (Variable)transition.getParameters().get(idx);
                    return parameter;
                }).collect(Collectors.toList());
                condition = transition.getGuard();
                idVarDef = transition.getIdVarDef();
                sb.append(PythonSBFCConverter.convertEventAction(eventPattern, (List<Expression>)patternParameters, (List<Variable>)patternVariables, condition, className, index));
            } else if (action instanceof EventCall) {
                event = ((EventCall)action).getEvent();
                eventPattern = ComponentUtilities.makeEvent((InterfaceEvent)event, null, (PortSelector)((EventCall)action), new ArrayList());
                patternParameters = ((EventCall)action).getParameters();
                idVar = ((EventCall)action).getIdVar();
                sb.append(PythonSBFCConverter.convertEventAction(eventPattern, (List<Expression>)patternParameters, patternVariables, condition, className, index));
            } else if (action instanceof EventWithVars) {
                event = ((EventWithVars)action).getEvent();
                eventPattern = ComponentUtilities.makeEvent((InterfaceEvent)event, null, (PortSelector)((EventWithVars)action), new ArrayList());
                patternVariables = event.getParameters().stream().filter(p -> p.getDirection() != DIRECTION.OUT).map(p -> {
                    int idx = event.getParameters().indexOf(p);
                    Variable parameter = (Variable)((EventWithVars)action).getParameters().get(idx);
                    return parameter;
                }).collect(Collectors.toList());
                idVarDef = ((EventWithVars)action).getIdVarDef();
                condition = ((EventWithVars)action).getCondition();
                extraFrontIndent = condition != null;
                sb.append(PythonSBFCConverter.convertEventAction(eventPattern, (List<Expression>)patternParameters, (List<Variable>)patternVariables, condition, className, index));
            } else if (action instanceof Reply) {
                Command command = PythonSBFCConverter.getCommand((Reply)action);
                eventPattern = ComponentUtilities.makeEvent(null, (Command)command, (PortSelector)((PortSelector)action), new ArrayList());
                if (action instanceof CommandReply) {
                    patternParameters = ((CommandReply)action).getParameters();
                    idVar = ((CommandReply)action).getIdVar();
                } else {
                    patternVariables = ((ActionWithVars)action).getParameters();
                    condition = ((ActionWithVars)action).getCondition();
                    extraFrontIndent = condition != null;
                    idVarDef = ((CommandReplyWithVars)action).getIdVarDef();
                }
                reply = PythonSBFCConverter.convertEventAction(eventPattern, (List<Expression>)patternParameters, (List<Variable>)patternVariables, condition, className, index);
            } else if (action instanceof AssignmentAction) {
                assignment = PythonSBFCConverter.convertAssignment((AssignmentAction)action, String.valueOf(extraFrontIndent ? "    " : "") + indent);
                assignments.add(assignment);
            } else if (action instanceof RecordFieldAssignmentAction) {
                assignment = PythonSBFCConverter.convertAssignment((RecordFieldAssignmentAction)action, String.valueOf(extraFrontIndent ? "    " : "") + indent);
                assignments.add(assignment);
            } else if (action instanceof StateTransitionAction) {
                StateTransitionAction stateAction = (StateTransitionAction)action;
                states.add(stateAction);
                nextState = stateAction.getNextState();
            } else if (action instanceof FunctionFragmentCall) {
                FunctionFragment function = ((FunctionFragmentCall)action).getFunctionFragment();
                int idx = 0;
                String funcString = PythonSBFCConverter.convertFunction(function, className, state);
                if (functions.contains(funcString)) {
                    idx = functions.indexOf(funcString);
                } else {
                    idx = functions.size();
                    functions.add(funcString);
                }
                functionCallString.add(String.format("%sself.function_%s(v)\n", condition != null ? String.valueOf(indent) + "    " : indent, idx));
                states.add(stateTrans);
            } else if (action instanceof IfAction) {
                assignments.add(PythonSBFCConverter.convertIfAction(action, className, state, nextState, index, String.valueOf(extraFrontIndent ? "    " : "") + indent));
            } else if (action instanceof IfHelperAction) {
                condition = ((IfHelperAction)action).getCondition();
                assignments.add(PythonSBFCConverter.convertIfAction(action, className, state, nextState, index, String.valueOf(extraFrontIndent ? "    " : "") + indent));
            } else {
                throw new RuntimeException("Action not supported");
            }
            if (idVar == null && idVarDef == null) continue;
            throw new RuntimeException("Connection variables not supported");
        }
        if (assignments.size() > 0) {
            sb.append(reply);
            for (String assignment : assignments) {
                sb.append(assignment);
            }
        } else {
            sb.append(reply);
        }
        int i = 0;
        while (i < functionCallString.size()) {
            sb.append((String)functionCallString.get(i));
            ++i;
        }
        if (states.size() > 0) {
            sb.append(PythonSBFCConverter.convertStateTransition(states.get(0), className, state, condition != null ? String.valueOf(indent) + "    " : indent));
        }
        return sb.toString();
    }

    private static String convertFunction(FunctionFragment function, String className, State state) {
        StringBuilder sb = new StringBuilder();
        for (Object action : function.getActions()) {
            if (action instanceof FunctionFragmentCall) {
                FunctionFragment funcFragment = ((FunctionFragmentCall)action).getFunctionFragment();
                sb.append(PythonSBFCConverter.convertFunction(funcFragment, className, state));
                continue;
            }
            if (action instanceof AssignmentAction || action instanceof RecordFieldAssignmentAction) {
                sb.append(PythonSBFCConverter.convertAssignment(action, "        "));
                continue;
            }
            if (action instanceof IfHelperAction) {
                sb.append(PythonSBFCConverter.convertIfAction(action, className, state, "", function.getMethodName(), "        "));
                continue;
            }
            if (action instanceof IfAction) {
                sb.append(PythonSBFCConverter.convertIfAction(action, className, state, "", function.getMethodName(), "        "));
                continue;
            }
            if (!(action instanceof StateTransitionAction)) continue;
            stateTrans = (StateTransitionAction)action;
        }
        return sb.toString();
    }

    private static String convertEventAction(EventPattern eventPattern, List<Expression> patternParameters, List<Variable> patternVariables, Expression condition, String className, String index) {
        boolean hasCondition;
        StringBuilder sb = new StringBuilder();
        String eventPatternStr = PythonSBFCConverter.convertEventPattern(eventPattern, patternParameters);
        String skipParameters = patternParameters.isEmpty() ? "True" : "False";
        sb.append(String.format("%sif index == %s and %s.equals(event, %s):\n", "                ", index, eventPatternStr, skipParameters));
        sb.append("                    v = cstate.variables.copy()\n");
        for (Variable v2 : patternVariables) {
            sb.append(String.format("%sv.%s = event.parameters[%d].value\n", "                    ", v2.getName(), patternVariables.indexOf(v2)));
        }
        boolean bl = hasCondition = condition != null;
        if (hasCondition) {
            sb.append(String.format("%sif %s:\n", "                    ", PythonHelper.expression(condition, v -> "v.", e -> PythonSBFCConverter.handleUnsupportedExpression(e))));
        }
        return sb.toString();
    }

    private static String convertEventPattern(EventPattern eventPattern, List<Expression> parameterExpressions) {
        List parameterTypes;
        String name;
        String type;
        String itf;
        String port;
        CommandEvent e;
        if (eventPattern instanceof CommandEvent) {
            e = (CommandEvent)eventPattern;
            port = e.getPort().getName();
            itf = e.getPort().getInterface().getName();
            type = "Command";
            name = ((Command)e.getEvent()).getName();
            parameterTypes = e.getEvent().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.OUT).map(p -> p.getType()).collect(Collectors.toList());
        } else if (eventPattern instanceof CommandReply) {
            e = (CommandReply)eventPattern;
            port = e.getPort().getName();
            itf = e.getPort().getInterface().getName();
            type = "Reply";
            name = e.getCommand().getEvent().getName();
            parameterTypes = e.getCommand().getEvent().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.IN).map(p -> p.getType()).collect(Collectors.toList());
            parameterTypes.add(((Command)e.getCommand().getEvent()).getType());
        } else if (eventPattern instanceof NotificationEvent) {
            e = (NotificationEvent)eventPattern;
            port = e.getPort().getName();
            itf = e.getPort().getInterface().getName();
            type = "Notification";
            name = ((Notification)e.getEvent()).getName();
            parameterTypes = e.getEvent().getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
        } else if (eventPattern instanceof SignalEvent) {
            e = (SignalEvent)eventPattern;
            port = e.getPort().getName();
            itf = e.getPort().getInterface().getName();
            type = "Signal";
            name = ((SignalImpl)e.getEvent()).getName();
            parameterTypes = e.getEvent().getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
        } else {
            throw new RuntimeException("Not supported");
        }
        String parametersStr = parameterExpressions.stream().map(expression -> {
            Type parameterType = (Type)parameterTypes.get(parameterExpressions.indexOf(expression));
            Function<String, String> variablePrefix = variable -> "str(" + variable + ")";
            return String.valueOf(PythonHelper.parameter(parameterType, expression, -1, variablePrefix)) + ".eval()";
        }).collect(Collectors.joining(", "));
        return String.format("Event(EventType.%s, '%s', '%s', '%s', [%s], PortDirection.Unknown)", type, itf, port, name, parametersStr);
    }

    private static Command getCommand(Reply r) {
        if (r.getCommand() != null) {
            return (Command)r.getCommand().getEvent();
        }
        TriggeredTransition transition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class);
        if (transition.getTrigger() != null && transition.getTrigger() instanceof Command) {
            return (Command)transition.getTrigger();
        }
        return null;
    }

    private static List<Expression> getEventPatternParameters(EventPattern eventPattern) {
        if (eventPattern instanceof CommandEventImpl) {
            return ((CommandEventImpl)eventPattern).getParameters();
        }
        if (eventPattern instanceof CommandReplyImpl) {
            return ((CommandReplyImpl)eventPattern).getParameters();
        }
        if (eventPattern instanceof NotificationEventImpl) {
            return ((NotificationEventImpl)eventPattern).getParameters();
        }
        if (eventPattern instanceof SignalEventImpl) {
            return ((SignalEventImpl)eventPattern).getParameters();
        }
        throw new RuntimeException("Not supported");
    }

    private static List<Parameter> getTriggeredTransitionParameters(TriggeredTransition transition) {
        List<Object> params = new ArrayList<Parameter>();
        if (transition.getTrigger() != null) {
            params = transition.getTrigger().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.OUT).collect(Collectors.toList());
        } else if (transition.getReplyTo() != null) {
            params = transition.getReplyTo().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.IN).collect(Collectors.toList());
        }
        return params;
    }
}

