"use strict";
var fs = require("fs");
var path = require("path");
var ts_module = require("typescript/lib/tsserverlibrary");
var createMatchers_1 = require("./helpers/createMatchers");
var cssSnapshots_1 = require("./helpers/cssSnapshots");
function init(_a) {
    var ts = _a.typescript;
    var _isCSS;
    function create(info) {
        // User options for plugin.
        var options = info.config.options || {};
        // Create matchers using options object.
        var _a = createMatchers_1.createMatchers(options), isCSS = _a.isCSS, isRelativeCSS = _a.isRelativeCSS;
        _isCSS = isCSS;
        // Creates new virtual source files for the CSS modules.
        var _createLanguageServiceSourceFile = ts.createLanguageServiceSourceFile;
        ts.createLanguageServiceSourceFile = function (fileName, scriptSnapshot) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            if (isCSS(fileName)) {
                scriptSnapshot = cssSnapshots_1.getDtsSnapshot(ts, fileName, scriptSnapshot, options);
            }
            var sourceFile = _createLanguageServiceSourceFile.apply(void 0, [fileName,
                scriptSnapshot].concat(rest));
            if (isCSS(fileName)) {
                sourceFile.isDeclarationFile = true;
            }
            return sourceFile;
        };
        // Updates virtual source files as files update.
        var _updateLanguageServiceSourceFile = ts.updateLanguageServiceSourceFile;
        ts.updateLanguageServiceSourceFile = function (sourceFile, scriptSnapshot) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            if (isCSS(sourceFile.fileName)) {
                scriptSnapshot = cssSnapshots_1.getDtsSnapshot(ts, sourceFile.fileName, scriptSnapshot, options);
            }
            sourceFile = _updateLanguageServiceSourceFile.apply(void 0, [sourceFile,
                scriptSnapshot].concat(rest));
            if (isCSS(sourceFile.fileName)) {
                sourceFile.isDeclarationFile = true;
            }
            return sourceFile;
        };
        if (info.languageServiceHost.resolveModuleNames) {
            var _resolveModuleNames_1 = info.languageServiceHost.resolveModuleNames.bind(info.languageServiceHost);
            info.languageServiceHost.resolveModuleNames = function (moduleNames, containingFile, reusedNames) {
                var resolvedModules = _resolveModuleNames_1(moduleNames, containingFile, reusedNames);
                return moduleNames.map(function (moduleName, index) {
                    try {
                        if (isRelativeCSS(moduleName)) {
                            return {
                                extension: ts_module.Extension.Dts,
                                isExternalLibraryImport: false,
                                resolvedFileName: path.resolve(path.dirname(containingFile), moduleName),
                            };
                        }
                        else if (isCSS(moduleName)) {
                            // TODO: Move this section to a separate file and add basic tests.
                            // Attempts to locate the module using TypeScript's previous search paths. These include "baseUrl" and "paths".
                            var failedModule = info.project.getResolvedModuleWithFailedLookupLocationsFromCache(moduleName, containingFile);
                            var baseUrl_1 = info.project.getCompilerOptions().baseUrl;
                            var match_1 = '/index.ts';
                            // An array of paths TypeScript searched for the module. All include .ts, .tsx, .d.ts, or .json extensions.
                            var failedLocations = failedModule
                                .failedLookupLocations;
                            // Filter to only one extension type, and remove that extension. This leaves us with the actual filename.
                            // Example: "usr/person/project/src/dir/File.module.css/index.d.ts" > "usr/person/project/src/dir/File.module.css"
                            var normalizedLocations = failedLocations.reduce(function (locations, location) {
                                if ((baseUrl_1 ? location.includes(baseUrl_1) : true) &&
                                    location.endsWith(match_1)) {
                                    return locations.concat([location.replace(match_1, '')]);
                                }
                                return locations;
                            }, []);
                            // Find the imported CSS module, if it exists.
                            var cssModulePath = normalizedLocations.find(function (location) {
                                return fs.existsSync(location);
                            });
                            if (cssModulePath) {
                                return {
                                    extension: ts_module.Extension.Dts,
                                    isExternalLibraryImport: false,
                                    resolvedFileName: path.resolve(cssModulePath),
                                };
                            }
                        }
                    }
                    catch (e) {
                        return resolvedModules[index];
                    }
                    return resolvedModules[index];
                });
            };
        }
        return info.languageService;
    }
    function getExternalFiles(project) {
        return project.getFileNames().filter(_isCSS);
    }
    return { create: create, getExternalFiles: getExternalFiles };
}
module.exports = init;
