/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.htmlwriter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.ease.helpgenerator.model.ExceptionValue;
import org.eclipse.ease.helpgenerator.model.Method;
import org.eclipse.ease.helpgenerator.model.Parameter;

public class SynopsisBuilder {
    private static final SynopsisBuilder INSTANCE = new SynopsisBuilder();

    public static SynopsisBuilder getInstance() {
        return INSTANCE;
    }

    private SynopsisBuilder() {
    }

    public String build(Method method) {
        return String.format("%s %s(%s)%s", this.createClassLink(method.getReturnType()), method.getName(), this.createParametersString(method.getParameters()), this.createExceptionString(method.getExceptions()));
    }

    private String createExceptionString(List<ExceptionValue> exceptions) {
        String exceptionString = exceptions.stream().map(except -> this.createClassLink((Parameter)except)).collect(Collectors.joining(", "));
        return exceptionString.isEmpty() ? "" : " throws " + exceptionString;
    }

    private String createParametersString(List<Parameter> parameters) {
        return parameters.stream().map(param -> String.format("%s%s %s%s", param.isOptional() ? "<i>[" : "", this.createClassLink((Parameter)param), param.getName(), param.isOptional() ? "]</i>" : "")).collect(Collectors.joining(", "));
    }

    private String createClassLink(Parameter parameter) {
        if ("void".equals(parameter.getTypeName())) {
            return "void";
        }
        String[] tokens = parameter.getTypeName().split("(?<=[,<>\\?])|(?=[,<>\\\\?])");
        return Arrays.asList(tokens).stream().map(token -> {
            switch (token) {
                case ",": {
                    return ", ";
                }
                case "<": {
                    return "&lt;";
                }
                case ">": {
                    return "&gt;";
                }
                case "?": {
                    return "?";
                }
            }
            String type = token.trim();
            if (type.endsWith("[]")) {
                return String.format("{@link %s}[]", type.substring(0, type.length() - 2));
            }
            return String.format("{@link %s}", type);
        }).collect(Collectors.joining());
    }
}

