/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.eventmanager.alarm;

import java.util.Date;
import org.eclipse.ebam.emf.interfaces.IAlarmTransactions;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.eventmanager.alarm.IAlarmEvent;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEvent
implements IAlarmEvent {
    private static Logger logger = LoggerFactory.getLogger(AlarmEvent.class);
    private IAlarmTransactions alarmTransactions = null;

    public final void createNewAlarm(IEbamEvent event) {
        logger.debug("IN");
        SbiAlarmEvent ev = new SbiAlarmEvent();
        SbiAlarm a = event.getSbiAlarm();
        ev.setActive("T");
        ev.setEventTs(new Date());
        ev.setSbiAlarm(a);
        IEbamMessage message = event.getMsg();
        if (message != null) {
            String serviceInstance = message.getServiceInstance();
            ev.setResources(serviceInstance);
        } else {
            logger.warn("Message inside alarm event was null, could not set servcie instance");
        }
        try {
            if (this.alarmTransactions != null) {
                this.alarmTransactions.alarmTransactionCreateNewSbiAlarmEvent(ev);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        logger.debug("OUT");
    }

    public void init(IAlarmTransactions a) {
        this.alarmTransactions = a;
    }
}

