/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterType;

public class StringFilterType
implements IFilterType {
    public static final String EQUALS = "equals";
    public static final String STARTS_WITH = "startsWith";
    public static final String CONTAINS = "contains";
    public static final String ENDS_WITH = "endsWith";
    private static final String[] operands = new String[]{"contains", "endsWith", "equals", "startsWith"};

    public String[] getOperators() {
        return operands;
    }

    public boolean processRule(IFilterAtom rule) {
        boolean result = rule.isNegated();
        if (rule.getOperator().equals(CONTAINS)) {
            result = this.contains(rule.getLeftOperand(), rule.getRightOperand());
        } else if (rule.getOperator().equals(ENDS_WITH)) {
            result = this.endsWith(rule.getLeftOperand(), rule.getRightOperand());
        } else if (rule.getOperator().equals(EQUALS)) {
            result = this.equals(rule.getLeftOperand(), rule.getRightOperand());
        } else if (rule.getOperator().equals(STARTS_WITH)) {
            result = this.startsWith(rule.getLeftOperand(), rule.getRightOperand());
        }
        if (rule.isNegated()) {
            return !result;
        }
        return result;
    }

    private boolean equals(String lhs, String rhs) {
        return lhs.equals(rhs);
    }

    private boolean contains(String lhs, String rhs) {
        int result = lhs.indexOf(rhs);
        return result != -1;
    }

    private boolean endsWith(String lhs, String rhs) {
        return lhs.endsWith(rhs);
    }

    private boolean startsWith(String lhs, String rhs) {
        return lhs.startsWith(rhs);
    }
}

