/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the ebam_event_attributes database table.
 * 
 */
@Entity
@Table(name="ebam_event_attributes")
public class EventAttribute implements Serializable {
	private static final long serialVersionUID = 1L;

	@TableGenerator(name="EAId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="EVENT_ATTR_ID", allocationSize=1)
	
  
	
	@Id
	@GeneratedValue(generator="EAId", strategy=GenerationType.TABLE)   
	@Column(name="EVENT_ATTR_ID")
	private int eventAttrId;

	@Column(name="EXPRESSION")
	private String expression;

	@Column(name="NAME")
	private String name;

	//bi-directional many-to-one association to EbamEventContent
	@OneToMany(mappedBy="ebamEventAttribute")
	private Set<EventContent> ebamEventContents;

	//bi-directional many-to-one association to EbamEvent
    @ManyToOne
	@JoinColumn(name="EVENT_ID")
	private Event ebamEvent;

    public EventAttribute() {
    }

	public int getEventAttrId() {
		return this.eventAttrId;
	}

	public void setEventAttrId(int eventAttrId) {
		this.eventAttrId = eventAttrId;
	}

	public String getExpression() {
		return this.expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Set<EventContent> getEbamEventContents() {
		return this.ebamEventContents;
	}

	public void setEbamEventContents(Set<EventContent> ebamEventContents) {
		this.ebamEventContents = ebamEventContents;
	}
	
	public Event getEbamEvent() {
		return this.ebamEvent;
	}

	public void setEbamEvent(Event ebamEvent) {
		this.ebamEvent = ebamEvent;
	}
	
}