/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the event_journal database table.
 * 
 */
@Entity
@Table(name="EBAM_EVENT_JOURNAL")
public class EventJournal implements Serializable {
	private static final long serialVersionUID = 1L;

	 @TableGenerator(name="EJId", table="ID_GEN",
	            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
	            pkColumnValue="EVENT_JOURNAL_ID", allocationSize=1)
		
	@Id
	@GeneratedValue(generator="EJId", strategy=GenerationType.TABLE)   
	@Column(name="EVENT_JOURNAL_ID")
	private Double eventJournalId;

	@Column(name="EVENT_DATA")
	private String eventData;

    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="TIMESTAMP")
	private Date timestamp;

	//bi-directional many-to-one association to Event
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="EVENT_ID")
	private Event event;

    public EventJournal() {
    }

	public double getEventJournalId() {
		return this.eventJournalId;
	}

	public void setEventJournalId(double eventJournalId) {
		this.eventJournalId = eventJournalId;
	}

	public String getEventData() {
		return this.eventData;
	}

	public void setEventData(String eventData) {
		this.eventData = eventData;
	}

	public Date getTimestamp() {
		return this.timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	public Event getEvent() {
		return this.event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}
	
}