/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MultipleFilesReader
extends Thread {
    private String dirName;
    private String fileName_regex;
    private Vector files = null;
    private int index;
    private static int timeout = 5;
    private static int MAX_CHAR = 1024;
    private RandomAccessFile tmpLog = null;
    protected String EOL_CHARS = System.getProperty("line.separator");
    protected char EOL_LAST_CHAR = (char)(System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? 21 : (int)this.EOL_CHARS.charAt(this.EOL_CHARS.length() - 1));

    public MultipleFilesReader(String dir, String f, RandomAccessFile tfile) {
        this.dirName = dir;
        if (!this.dirName.endsWith(File.separator)) {
            this.dirName = String.valueOf(this.dirName) + File.separator;
        }
        this.tmpLog = tfile;
        this.fileName_regex = f;
        this.setName("MultipleFilesReader");
    }

    public void init() {
        if (this.dirName != null) {
            File dir = new File(this.dirName);
            if (!dir.isDirectory()) {
                this.reset();
                return;
            }
            File[] allFiles = dir.listFiles();
            if (this.fileName_regex != null) {
                Pattern pat;
                this.files = new Vector();
                try {
                    pat = Pattern.compile(this.fileName_regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.reset();
                    return;
                }
                int i = 0;
                while (i < allFiles.length) {
                    Matcher mat = pat.matcher(allFiles[i].getName());
                    if (mat.matches()) {
                        boolean added = false;
                        int j = 0;
                        while (j < this.files.size() && !added) {
                            File f = new File((String)this.files.elementAt(j));
                            if (allFiles[i].lastModified() < f.lastModified()) {
                                this.files.insertElementAt(String.valueOf(this.dirName) + File.separator + allFiles[i].getName(), j);
                                added = true;
                            }
                            ++j;
                        }
                        if (!added) {
                            this.files.add(String.valueOf(this.dirName) + allFiles[i].getName());
                        }
                    }
                    ++i;
                }
            }
        }
        this.reset();
    }

    public void reset() {
        this.index = 0;
    }

    public int size() {
        if (this.files == null) {
            return 0;
        }
        return this.files.size();
    }

    public boolean hasNext() {
        return this.index < this.files.size();
    }

    public String getNext() {
        if (this.index < this.files.size()) {
            return (String)this.files.elementAt(this.index++);
        }
        return null;
    }

    public void loadConsolidatedFile() {
        if (this.tmpLog != null) {
            while (this.hasNext()) {
                this.appendToTempFile(this.getNext());
            }
        }
    }

    public void run() {
        String previousFileName = null;
        String currentFileName = null;
        RandomAccessFile previousFile = null;
        RandomAccessFile currentFile = null;
        byte[] buf = null;
        int bufLen = 0;
        int byteCopied = 0;
        if (this.tmpLog != null) {
            while (this.hasNext()) {
                previousFileName = currentFileName;
                currentFileName = this.getNext();
                byteCopied = this.appendToTempFile(currentFileName);
            }
            buf = new byte[MAX_CHAR];
            this.bzero(buf);
            bufLen = 0;
            while (currentFileName != null) {
                try {
                    currentFile = new RandomAccessFile(currentFileName, "r");
                    if (currentFile.length() < (long)byteCopied) {
                        previousFile = new RandomAccessFile(previousFileName, "r");
                        previousFile.seek(byteCopied);
                        if ((long)byteCopied < previousFile.length()) {
                            while ((long)byteCopied < previousFile.length()) {
                                this.tmpLog.write(previousFile.readByte());
                                ++byteCopied;
                            }
                        }
                        previousFile.close();
                        byteCopied = 0;
                    }
                    currentFile.seek(byteCopied);
                    if ((long)byteCopied < currentFile.length()) {
                        while ((long)byteCopied < currentFile.length()) {
                            byte a = currentFile.readByte();
                            buf[bufLen++] = a;
                            if (a == this.EOL_LAST_CHAR) {
                                this.tmpLog.write(buf, 0, bufLen);
                                this.bzero(buf);
                                bufLen = 0;
                            }
                            ++byteCopied;
                        }
                    }
                    currentFile.close();
                    Thread.sleep(timeout * 1000);
                }
                catch (Exception exception) {
                    return;
                }
            }
        } else {
            return;
        }
    }

    private void bzero(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = 0;
            ++i;
        }
    }

    private synchronized int appendToTempFile(String src) {
        int len = 0;
        byte[] buf = null;
        if (this.tmpLog != null) {
            RandomAccessFile in;
            try {
                in = new RandomAccessFile(src, "r");
                this.tmpLog.seek(this.tmpLog.length());
                len = (int)in.length();
                buf = new byte[len];
                len = in.read(buf, 0, len);
                this.tmpLog.write(buf);
            }
            catch (Exception exception) {
                return 0;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return len;
    }
}

