/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.commands.equinox;

import java.util.List;
import org.eclipse.ebpm.core.registry.ISpagicRegistry;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class SpagicCommands
implements CommandProvider {
    public static final String SPAGIC_SERVICE = "SPAGIC_SERVICE";
    public static final String SPAGIC_CONNECTOR = "SPAGIC_CONNECTOR";
    public static final String SPAGIC_DATASOURCE = "SPAGIC_DATASOURCE";
    public static final String SPAGIC_TYPE = "SPAGIC_TYPE";
    private ISpagicRegistry spagicRegistry;
    private BundleContext context = null;

    protected void activate(ComponentContext componentContext) {
        this.context = componentContext.getBundleContext();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.context = null;
    }

    private void internalSpagicServiceCmd(String filter, CommandInterpreter intp) {
        try {
            int size;
            ServiceReference[] services = this.context.getServiceReferences(null, filter);
            if (services != null && (size = services.length) > 0) {
                int j = 0;
                while (j < size) {
                    ServiceReference service = services[j];
                    intp.println((Object)service);
                    intp.print((Object)"  ");
                    intp.print((Object)"Bundle ");
                    intp.print((Object)" ");
                    intp.println((Object)service.getBundle());
                    ++j;
                }
                return;
            }
            intp.println((Object)" NO SPAGIC SERVICES ");
        }
        catch (Exception e) {
            intp.printStackTrace((Throwable)e);
        }
    }

    private String makeFilter(String filterStart, CommandInterpreter ci) {
        StringBuilder filter = new StringBuilder(filterStart);
        boolean first = true;
        String next = ci.nextArgument();
        while (next != null) {
            if (first) {
                filter.append("(|");
                first = false;
            }
            filter.append("(spagic.id=");
            filter.append(next);
            filter.append(")");
            next = ci.nextArgument();
        }
        if (!first) {
            filter.append(")");
        }
        filter.append(")");
        return filter.toString();
    }

    public void _spagic_connector(CommandInterpreter ci) {
        this.internalSpagicServiceCmd(this.makeFilter("(&(objectClass=org.eclipse.ebpm.core.ISpagicService)(SPAGIC_TYPE=SPAGIC_CONNECTOR)", ci), ci);
    }

    public void _spagic_service(CommandInterpreter ci) {
        this.internalSpagicServiceCmd(this.makeFilter("(&(objectClass=org.eclipse.ebpm.core.ISpagicService)(SPAGIC_TYPE=SPAGIC_SERVICE)", ci), ci);
    }

    public void _spagic_registry(CommandInterpreter intp) {
        List snapshot = this.spagicRegistry.getSnaphshot();
        intp.println((Object)" ********* SPAGIC_REGISTRY_SNAPSHOT");
        for (String s : snapshot) {
            intp.println((Object)("--> " + s));
        }
    }

    public void _spagic_datasource(CommandInterpreter ci) {
        this.internalSpagicServiceCmd(this.makeFilter("(&(objectClass=javax.sql.DataSource)(SPAGIC_TYPE=SPAGIC_DATASOURCE)", ci), ci);
    }

    public void _spagic_stop_connector(CommandInterpreter ci) {
    }

    public void _spagic_start_connector(CommandInterpreter ci) {
    }

    public void _spagic_pause_connector(CommandInterpreter ci) {
    }

    public void _spagic_components(CommandInterpreter ci) {
    }

    public void _spagic_pending_deployments(CommandInterpreter ci) {
    }

    public void _spagic_services(CommandInterpreter ci) {
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---SPAGIC COMMAND HELP---\n");
        return buffer.toString();
    }

    public void bindRegistry(ISpagicRegistry registry) {
        this.spagicRegistry = registry;
    }

    public void unbindRegistry(ISpagicRegistry registry) {
        this.spagicRegistry = null;
    }
}

