/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.Logging;
import org.eclipse.equinox.metatype.MetaTypeInformationImpl;
import org.eclipse.equinox.metatype.MetaTypeProviderTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public class MetaTypeServiceImpl
implements MetaTypeService,
SynchronousBundleListener {
    BundleContext _context;
    SAXParserFactory _parserFactory;
    private Hashtable _mtps = new Hashtable(7);

    public MetaTypeServiceImpl(BundleContext context, SAXParserFactory parserFactory) {
        this._context = context;
        this._parserFactory = parserFactory;
    }

    public MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        MetaTypeInformation mti;
        try {
            mti = this.getMetaTypeProvider(bundle);
        }
        catch (IOException e) {
            Logging.log(3, "IOException in MetaTypeInformation:getMetaTypeInformation(Bundle bundle)");
            e.printStackTrace();
            mti = null;
        }
        return mti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaTypeInformation getMetaTypeProvider(final Bundle b) throws IOException {
        try {
            Long bID = new Long(b.getBundleId());
            Hashtable hashtable = this._mtps;
            synchronized (hashtable) {
                if (this._mtps.containsKey(bID)) {
                    return (MetaTypeInformation)this._mtps.get(bID);
                }
                MetaTypeInformation mti = (MetaTypeInformation)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        MetaTypeInformationImpl impl = new MetaTypeInformationImpl(b, MetaTypeServiceImpl.this._parserFactory);
                        if (!impl._isThereMeta) {
                            return new MetaTypeProviderTracker(MetaTypeServiceImpl.this._context, b);
                        }
                        return impl;
                    }
                });
                this._mtps.put(bID, mti);
                return mti;
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Long bID = new Long(event.getBundle().getBundleId());
        switch (type) {
            case 8: 
            case 16: {
                this._mtps.remove(bID);
                break;
            }
        }
    }
}

