/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.eclipse.ebpm.components.jdbc.TypesUtils;
import org.eclipse.ebpm.components.jdbc.config.JDBCParameterFactory;
import org.eclipse.ebpm.components.jdbc.config.QueryParameterConfig;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.w3c.dom.Document;

public class StoreProcedureRunner
extends QueryRunner {
    public Object call(Connection conn, String call, Message in, List<QueryParameterConfig> queryParametersConfig, List<String> orderedParameterNamesList, ResultSetHandler rsh) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        Object result = null;
        Object[] inputParams = null;
        try {
            stmt = conn.prepareCall(call);
            inputParams = this.fillStatement(stmt, queryParametersConfig, orderedParameterNamesList, in);
            stmt.execute();
            Object[] objectArray = this.retrieveOutValues(queryParametersConfig, orderedParameterNamesList, stmt, rsh);
            return objectArray;
        }
        catch (SQLException e) {
            this.rethrow(e, call, inputParams);
        }
        catch (Exception e) {
            this.rethrow(new SQLException(e.getMessage()), call, inputParams);
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
            }
        }
        return result;
    }

    protected Object[] retrieveOutValues(List<QueryParameterConfig> queryParametersConfig, List<String> orderedParameterNamesList, CallableStatement stmt, ResultSetHandler rsh) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            int i = 0;
            while (i < orderedParameterNamesList.size()) {
                String paramName = orderedParameterNamesList.get(i);
                for (QueryParameterConfig qpc : queryParametersConfig) {
                    if (qpc.getPlaceHolder().compareToIgnoreCase(paramName) != 0 || !qpc.isOutputParam()) continue;
                    Object elem = stmt.getObject(this.findParameterPosition(qpc.getPlaceHolder(), orderedParameterNamesList));
                    if (elem instanceof ResultSet) {
                        list.add(rsh.handle((ResultSet)elem));
                        break;
                    }
                    list.add(elem);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return list.toArray();
    }

    protected Object[] fillStatement(CallableStatement stmt, List<QueryParameterConfig> queryParametersConfig, List<String> orderedParameterNamesList, Message in) throws Exception {
        ArrayList<Object> inputParams = new ArrayList<Object>();
        Document inMsgDoc = new SourceTransformer().toDOMDocument(in);
        EXMLUtils xmlUtils = new EXMLUtils(DOM4JUtils.getNamespaceContext((Document)inMsgDoc));
        try {
            JDBCParameterFactory factory = JDBCParameterFactory.getInstance();
            HashMap<String, QueryParameterConfig> tempQueryParMap = new HashMap<String, QueryParameterConfig>();
            for (QueryParameterConfig queryParameterConfig : queryParametersConfig) {
                tempQueryParMap.put(queryParameterConfig.getPlaceHolder(), queryParameterConfig);
            }
            for (String paramName : orderedParameterNamesList) {
                QueryParameterConfig aQueryParameterConfig = (QueryParameterConfig)tempQueryParMap.get(paramName);
                int parameterPosition = this.findParameterPosition(aQueryParameterConfig.getPlaceHolder(), orderedParameterNamesList);
                if (aQueryParameterConfig.isOutputParam()) {
                    stmt.registerOutParameter(parameterPosition, TypesUtils.getSqlTypeByName(aQueryParameterConfig.getParamType()));
                    continue;
                }
                Object param = null;
                param = factory.initializeParameter(inMsgDoc, xmlUtils, aQueryParameterConfig);
                inputParams.add(param);
                if (param != null) {
                    stmt.setObject(parameterPosition, param);
                    continue;
                }
                stmt.setNull(parameterPosition, 12);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return inputParams.toArray();
    }

    public int findParameterPosition(String parameterName, List<String> orderedParameterNames) throws Exception {
        int inList = orderedParameterNames.indexOf(parameterName);
        if (inList != -1) {
            return inList + 1;
        }
        throw new Exception(" Parameter [" + parameterName + "] not found in parameter List");
    }
}

