/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javadoc.AnnotationValueImpl;
import com.sun.tools.javadoc.DocEnv;

public class AnnotationDescImpl
implements AnnotationDesc {
    private final DocEnv env;
    private final Attribute.Compound annotation;

    AnnotationDescImpl(DocEnv docEnv, Attribute.Compound compound) {
        this.env = docEnv;
        this.annotation = compound;
    }

    public AnnotationTypeDoc annotationType() {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.annotation.type.tsym;
        return (AnnotationTypeDoc)((Object)this.env.getClassDoc(classSymbol));
    }

    public AnnotationDesc.ElementValuePair[] elementValues() {
        List<Pair<Symbol.MethodSymbol, Attribute>> list = this.annotation.values;
        AnnotationDesc.ElementValuePair[] elementValuePairArray = new AnnotationDesc.ElementValuePair[list.length()];
        int n = 0;
        for (Pair<Symbol.MethodSymbol, Attribute> pair : list) {
            elementValuePairArray[n++] = new ElementValuePairImpl(this.env, (Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
        }
        return elementValuePairArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.annotation.type.tsym);
        AnnotationDesc.ElementValuePair[] elementValuePairArray = this.elementValues();
        if (elementValuePairArray.length > 0) {
            stringBuffer.append('(');
            boolean bl = true;
            for (AnnotationDesc.ElementValuePair elementValuePair : elementValuePairArray) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                String string = elementValuePair.element().name();
                if (elementValuePairArray.length == 1 && string.equals("value")) {
                    stringBuffer.append(elementValuePair.value());
                    continue;
                }
                stringBuffer.append(elementValuePair);
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static class ElementValuePairImpl
    implements AnnotationDesc.ElementValuePair {
        private final DocEnv env;
        private final Symbol.MethodSymbol meth;
        private final Attribute value;

        ElementValuePairImpl(DocEnv docEnv, Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            this.env = docEnv;
            this.meth = methodSymbol;
            this.value = attribute;
        }

        public AnnotationTypeElementDoc element() {
            return this.env.getAnnotationTypeElementDoc(this.meth);
        }

        public AnnotationValue value() {
            return new AnnotationValueImpl(this.env, this.value);
        }

        public String toString() {
            return this.meth.name + "=" + this.value();
        }
    }
}

