/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import java.util.List;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="createEnumeration", label="Create Enumeration", description="In the metamodel, an enumeration is created. In the model, nothing needs to be changed.")
public class CreateEnumeration
extends OperationImplementation {
    @EdaptParameter(main=true, description="The package in which the enumeration is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the new enumeration")
    public String name;
    @EdaptParameter(optional=true, description="The names of the literals of the new enumeration")
    public List<String> literals;

    public void execute(Metamodel metamodel, Model model) {
        EEnum eEnum = MetamodelFactory.newEEnum((EPackage)this.ePackage, (String)this.name);
        int i = 0;
        for (String literal : this.literals) {
            EEnumLiteral eLiteral = MetamodelFactory.newEEnumLiteral((EEnum)eEnum, (String)literal);
            eLiteral.setValue(i);
            ++i;
        }
    }
}

