/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractEGLLaunchShortcut
implements ILaunchShortcut2 {
    protected abstract void doLaunch(IFile var1, String var2);

    public void launch(ISelection selection, String mode) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            MessageDialog.openError((Shell)DebugUtil.getShell(), (String)EGLLaunchingMessages.launch_error_dialog_title, (String)EGLLaunchingMessages.launch_shortcut_usage);
            return;
        }
        ArrayList<IFile> eglFiles = new ArrayList<IFile>();
        for (Object obj : (IStructuredSelection)selection) {
            IFile file;
            String name;
            if (obj instanceof IEGLElement) {
                IEGLElement element = (IEGLElement)obj;
                try {
                    String name2;
                    IResource file2 = element.getUnderlyingResource();
                    if (file2.getType() != 1 || !DebugUtil.isEGLFileName((String)(name2 = file2.getName()))) continue;
                    eglFiles.add((IFile)file2);
                }
                catch (EGLModelException eGLModelException) {}
                continue;
            }
            if (!(obj instanceof IFile) || !DebugUtil.isEGLFileName((String)(name = (file = (IFile)obj).getName()))) continue;
            eglFiles.add(file);
        }
        if (eglFiles.size() == 0) {
            MessageDialog.openError((Shell)DebugUtil.getShell(), (String)EGLLaunchingMessages.launch_error_dialog_title, (String)EGLLaunchingMessages.launch_shortcut_missing_file_error);
            return;
        }
        if (eglFiles.size() > 1) {
            MessageDialog.openError((Shell)DebugUtil.getShell(), (String)EGLLaunchingMessages.launch_error_dialog_title, (String)EGLLaunchingMessages.launch_shortcut_multiple_files_error);
            return;
        }
        this.doLaunch((IFile)eglFiles.get(0), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        IFile ifile;
        IEditorInput input = editor.getEditorInput();
        IEGLElement ee = (IEGLElement)input.getAdapter(IEGLElement.class);
        if (ee != null) {
            this.launch((ISelection)new StructuredSelection((Object)ee), mode);
        }
        if ((ifile = (IFile)input.getAdapter(IFile.class)) != null) {
            this.launch((ISelection)new StructuredSelection((Object)ifile), mode);
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            return this.getLaunchableResource((IAdaptable)element);
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getLaunchableResource((IAdaptable)editorpart.getEditorInput());
    }

    private IResource getLaunchableResource(IAdaptable adaptable) {
        IEGLElement ee = (IEGLElement)adaptable.getAdapter(IEGLElement.class);
        if (ee != null) {
            return ee.getResource();
        }
        return null;
    }
}

