/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.sql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.DatabaseHelper;
import org.eclipse.datatools.modelbase.sql.schema.helper.SchemaHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.edt.ide.sql.SQLNlsStrings;
import org.eclipse.edt.ide.sql.SQLPlugin;

public class EGLSQLUtility {
    public static String[] tokenizeName(String name) {
        char[] nameChars = name.toCharArray();
        char[][] tokens = new char[][]{new char[nameChars.length], new char[nameChars.length], new char[nameChars.length]};
        boolean delimiter = false;
        int token = 0;
        int index = 0;
        int i = 0;
        while (i < nameChars.length) {
            if (nameChars[i] == '\"') {
                delimiter = !delimiter;
                tokens[token][index++] = nameChars[i];
            } else if (nameChars[i] == '.' && !delimiter) {
                index = 0;
                if (++token > 2) {
                    break;
                }
            } else {
                tokens[token][index++] = nameChars[i];
            }
            ++i;
        }
        String[] result = new String[3];
        result[2] = new String(tokens[token]).trim();
        result[1] = token > 0 ? new String(tokens[token - 1]).trim() : null;
        result[0] = token > 1 ? new String(tokens[token - 2]).trim() : null;
        return result;
    }

    public static boolean isDelimitedIdentifier(String id) {
        String del = "\"";
        return id.startsWith(del) && id.endsWith(del) && id.length() > 1;
    }

    public static Table findTable(Database database, String tableName) {
        Schema sch;
        String[] nameTokens = EGLSQLUtility.tokenizeName(tableName);
        String schName = nameTokens[1];
        String tblName = nameTokens[2];
        if (schName != null && (sch = EGLSQLUtility.findSchema(database, schName)) != null) {
            return SchemaHelper.findTable((Schema)sch, (String)tblName);
        }
        return null;
    }

    public static Schema findSchema(Database database, String schemaName) {
        return DatabaseHelper.findSchema((Database)database, (String)schemaName);
    }

    public static IConnectionProfile getCurrentConnectionProfile() {
        String conName = SQLPlugin.getPlugin().getNamedConnection();
        return EGLSQLUtility.getConnectionProfile(conName);
    }

    public static IConnectionProfile getConnectionProfile(String connectionName) {
        IConnectionProfile profile = null;
        if (connectionName != null && connectionName.length() > 0) {
            profile = ProfileManager.getInstance().getProfileByName(connectionName);
        }
        return profile;
    }

    public static List<String> getExistingConnectionNamesList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        ArrayList<String> nameList = new ArrayList<String>(profiles.length);
        int i = 0;
        int n = profiles.length;
        while (i < n) {
            if (!nameList.contains(profiles[i].getName())) {
                nameList.add(profiles[i].getName());
            }
            ++i;
        }
        return nameList;
    }

    public static String getSQLDatabaseVendorPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = (String)profile.getBaseProperties().get("org.eclipse.datatools.connectivity.db.vendor");
        }
        return name;
    }

    public static String getSQLJDBCDriverClassPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        }
        return name;
    }

    public static String getSQLDatabasePreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        return name;
    }

    public static String getSQLConnectionURLPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        return name;
    }

    public static String getSQLJDBCLoadingPath() {
        String path = "";
        IConnectionProfile profile = EGLSQLUtility.getCurrentConnectionProfile();
        if (profile != null) {
            path = EGLSQLUtility.getLoadingPath(profile);
        }
        return path;
    }

    public static String getSQLUserId(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username");
    }

    public static String getSQLPassword(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public static String getSQLVendorProperty(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public static String getSQLProductVersion(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public static String getDBProfileProviderName(IConnectionProfile profile) {
        return profile.getProviderName();
    }

    public static String getDBNameProperty(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public static String getDefaultSchema(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.defaultSchema");
    }

    public static String getDecodedConnectionPassword(IConnectionProfile connection) {
        Properties props;
        String password = "";
        if (connection != null && (password = (props = connection.getProperties("EGL_CUSTOM_PROPERTIES")).getProperty("EGL_DB_PASSWORD", "")).length() > 0 && Encoder.isEncoded((String)password)) {
            password = Encoder.decode((String)password);
        }
        return password;
    }

    public static void shutdownConnection(IConnectionProfile profile) {
        String url = EGLSQLUtility.getSQLConnectionURLPreference(profile);
        if (url != null && url.startsWith("jdbc:derby:")) {
            profile.disconnect(null);
        }
    }

    public static String getLoadingPath(IConnectionProfile connectionProfile) {
        DriverInstance driverInstance;
        String jarList = null;
        String driverID = connectionProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverID != null && (driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverID)) != null) {
            jarList = driverInstance.getJarList();
        }
        return jarList;
    }

    public static String getSecondaryID(IConnectionProfile profile) {
        String id = "";
        Properties props = profile.getProperties("EGL_CUSTOM_PROPERTIES");
        if (props != null) {
            id = props.getProperty("EGL_SECONDARY_ID", "");
        }
        return id;
    }

    public static IConnectionProfile createNewProfile() {
        AddProfileViewAction action = new AddProfileViewAction();
        action.run();
        return action.getAddedProfile();
    }

    public static ConnectionDisplayProperty[] getConnectionDisplayProperties(IConnectionProfile profile) {
        ConnectionDisplayProperty[] properties = new ConnectionDisplayProperty[]{new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_DATABASE_PROPERTY, EGLSQLUtility.getDBProfileProviderName(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_DBNAME_PROPERTY, EGLSQLUtility.getDBNameProperty(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_JDBC_PROPERTY, EGLSQLUtility.getSQLJDBCDriverClassPreference(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_LOCATION_PROPERTY, EGLSQLUtility.getLoadingPath(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_URL_PROPERTY, EGLSQLUtility.getSQLConnectionURLPreference(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_USER_ID_PROPERTY, EGLSQLUtility.getSQLUserId(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_USER_PASSWORD_PROPERTY, EGLSQLUtility.getSQLPassword(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_JNDI_PROPERTY, "jdbc/" + EGLSQLUtility.getDBNameProperty(profile)), new ConnectionDisplayProperty(SQLNlsStrings.SQL_BINDING_NAME_PROPERTY, profile.getName()), new ConnectionDisplayProperty(SQLNlsStrings.SQL_CONNECTION_DEFAULT_SCHEMA_PROPERTY, EGLSQLUtility.getDefaultSchema(profile))};
        return properties;
    }

    public static String getConnectionProviderProfile(String vendorName) {
        for (Object next : ConnectionProfileManager.getInstance().getProviders().values()) {
            IConnectionProfileProvider provider = (IConnectionProfileProvider)next;
            if (provider == null || !vendorName.equals(provider.getName())) continue;
            return provider.getId();
        }
        return null;
    }
}

