/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Structure;
import eglx.lang.AnyException;
import eglx.lang.AnyValue;
import eglx.lang.EAny;
import eglx.lang.InvalidArgumentException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.java.jtopen.access.AS400Array;
import org.eclipse.edt.java.jtopen.access.AS400Timestamp;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.EList;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETime;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class AS400Converter {
    public AS400Converter xx;

    public static Object convertFromAS400(Object eglObject, Object as400ConvertedData) throws AnyException {
        if (eglObject instanceof AnyBoxedObject) {
            ((AnyBoxedObject)eglObject).ezeCopy(AS400Converter.convertFromAS400(((AnyBoxedObject)eglObject).ezeUnbox(), as400ConvertedData));
            return eglObject;
        }
        if (eglObject instanceof List) {
            int idx = 0;
            while (idx < ((List)eglObject).size()) {
                ((List)eglObject).set(idx, AS400Converter.convertFromAS400(((List)eglObject).get(idx), ((Object[])as400ConvertedData)[idx]));
                ++idx;
            }
            return eglObject;
        }
        if (eglObject instanceof AnyValue) {
            return AS400Converter.convertFromAS400Structure(eglObject, as400ConvertedData);
        }
        if (eglObject instanceof ExecutableBase) {
            return AS400Converter.convertFromAS400Structure(eglObject, as400ConvertedData);
        }
        return as400ConvertedData;
    }

    private static Object convertFromAS400Structure(Object object, Object as400ConvertedData) throws AnyException {
        int idx = 0;
        for (Field field : AS400Converter.getFields(object.getClass())) {
            String name = field.getName();
            try {
                StringBuilder setterName = new StringBuilder(field.getName().substring(0, 1).toUpperCase());
                setterName.append(field.getName().substring(1));
                Method setMethod = null;
                try {
                    setMethod = object.getClass().getMethod("set" + setterName, field.getType());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                Method getMethod = null;
                try {
                    getMethod = object.getClass().getMethod("get" + setterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (getMethod == null) {
                    try {
                        getMethod = object.getClass().getMethod("is" + setterName, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                Object existingFieldObject = null;
                if (getMethod != null && Modifier.isPublic(getMethod.getModifiers())) {
                    existingFieldObject = getMethod.invoke(object, null);
                } else if (Modifier.isPublic(field.getModifiers())) {
                    existingFieldObject = field.get(object);
                }
                if ((getMethod == null || !Modifier.isPublic(getMethod.getModifiers())) && !Modifier.isPublic(field.getModifiers())) continue;
                Object newEglValue = AS400Converter.convertFromAS400(existingFieldObject, ((Object[])as400ConvertedData)[idx++]);
                if (setMethod != null && Modifier.isPublic(setMethod.getModifiers())) {
                    setMethod.invoke(object, newEglValue);
                    continue;
                }
                if (!Modifier.isPublic(field.getModifiers())) continue;
                field.set(object, newEglValue);
            }
            catch (Throwable t) {
                InvalidArgumentException ex = new InvalidArgumentException();
                ex.initCause(t);
                ex.setMessageID("convertFromAS400Structure");
                ex.setMessage("Error convertFromAS400Structure field:" + name);
                throw ex;
            }
        }
        return object;
    }

    public static Object convertToObjects(Object object, AS400DataType as400Datatype) {
        if (object instanceof AnyBoxedObject) {
            return AS400Converter.convertToObjects(((AnyBoxedObject)object).ezeUnbox(), as400Datatype);
        }
        if (object instanceof List && as400Datatype instanceof AS400Array) {
            ArrayList<Object> array = new ArrayList<Object>();
            AS400DataType arrayElementsAS400Type = ((AS400Array)as400Datatype).getType();
            if (array.size() != ((AS400Array)as400Datatype).getNumberOfElements()) {
                AS400Converter.resizeList((List)object, (AS400Array)as400Datatype);
            }
            for (Object element : (List)object) {
                array.add(AS400Converter.convertToObjects(element, arrayElementsAS400Type));
            }
            return array.toArray(new Object[array.size()]);
        }
        if (object instanceof AnyValue && as400Datatype instanceof AS400Structure) {
            return AS400Converter.convertStructureToObjects(object, (AS400Structure)as400Datatype);
        }
        if (object instanceof ExecutableBase && as400Datatype instanceof AS400Structure) {
            return AS400Converter.convertStructureToObjects(object, (AS400Structure)as400Datatype);
        }
        return object;
    }

    private static Object convertStructureToObjects(Object object, AS400Structure as400Datatype) throws AnyException {
        ArrayList<Object> convertedFields = new ArrayList<Object>();
        AS400DataType[] as400Fields = as400Datatype.getMembers();
        int as400Idx = 0;
        for (Field field : AS400Converter.getFields(object.getClass())) {
            String name = field.getName();
            try {
                StringBuilder getterName = new StringBuilder(field.getName().substring(0, 1).toUpperCase());
                getterName.append(field.getName().substring(1));
                Method method = null;
                try {
                    method = object.getClass().getMethod("get" + getterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method == null) {
                    try {
                        method = object.getClass().getMethod("is" + getterName, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                if (method != null && Modifier.isPublic(method.getModifiers())) {
                    convertedFields.add(AS400Converter.convertToObjects(method.invoke(object, null), as400Fields[as400Idx++]));
                    continue;
                }
                if (!Modifier.isPublic(field.getModifiers())) continue;
                convertedFields.add(AS400Converter.convertToObjects(field.get(object), as400Fields[as400Idx++]));
            }
            catch (Throwable t) {
                InvalidArgumentException ex = new InvalidArgumentException();
                ex.initCause(t);
                ex.setMessageID("convertStructureToObjects");
                ex.setMessage("Error convert AS400 objects to a structure field:" + name);
                throw ex;
            }
        }
        return convertedFields.toArray(new Object[convertedFields.size()]);
    }

    private static void resizeList(List list, AS400Array as400Array) {
        if (EBigint.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.BigintFactory);
        } else if (EDate.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.DateFactory);
        } else if (EDecimal.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.DecimalFactory);
        } else if (EFloat.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.FloatFactory);
        } else if (EInt.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.IntFactory);
        } else if (ESmallfloat.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.SmallfloatFactory);
        } else if (ESmallint.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.SmallintFactory);
        } else if (EString.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.StringFactory);
        } else if (ETime.class.equals(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)EList.TimeFactory);
        } else if (ETimestamp.class.equals(as400Array.getEGLElementType())) {
            AS400DataType elementType = as400Array.getType();
            while (elementType instanceof AS400Array) {
                elementType = ((AS400Array)elementType).getType();
            }
            if (elementType instanceof AS400Timestamp) {
                EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)new EList.TimestampFactory(((AS400Timestamp)elementType).getStartCode(), ((AS400Timestamp)elementType).getEndCode()));
            }
        } else if (AnyValue.class.isAssignableFrom(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)new EList.ElementFactory(as400Array.getEGLElementType()));
        } else if (ExecutableBase.class.isAssignableFrom(as400Array.getEGLElementType())) {
            EList.resize((List)list, (int)as400Array.getNumberOfElements(), (EList.ListElementFactory)new EList.ElementFactory(as400Array.getEGLElementType()));
        }
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while (EAny.class.isAssignableFrom(clazz = clazz.getSuperclass()) || Executable.class.isAssignableFrom(clazz));
        return fields;
    }
}

