/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.AbstractScalarExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.IAbstractConditionalExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.IScalarExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AllOrAnyExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AndExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.BetweenExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionMemberExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EmptyCollectionComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ExistsExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.InExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.KeywordExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LikeExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LowerExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.NullComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleSelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SubExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SubstringExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.TrimExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpperExpressionStateObject;

public abstract class AbstractConditionalExpressionStateObjectBuilder<T extends IAbstractConditionalExpressionStateObjectBuilder<T>>
extends AbstractScalarExpressionStateObjectBuilder<T>
implements IAbstractConditionalExpressionStateObjectBuilder<T> {
    public AbstractConditionalExpressionStateObjectBuilder(StateObject parent) {
        super(parent);
    }

    @Override
    public T all(SimpleSelectStatementStateObject subquery) {
        this.allOrAny("ALL", subquery);
        return (T)this;
    }

    protected void allOrAny(String identifier, SimpleSelectStatementStateObject subquery) {
        AllOrAnyExpressionStateObject stateObject = new AllOrAnyExpressionStateObject(this.getParent(), identifier, subquery);
        this.add(stateObject);
    }

    @Override
    public T and(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        AndExpressionStateObject stateObject = new AndExpressionStateObject(this.getParent(), leftStateObject, rightStateObject);
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T any(SimpleSelectStatementStateObject subquery) {
        this.allOrAny("ANY", subquery);
        return (T)this;
    }

    protected void between(boolean not) {
        StateObject upperBoundStateObject = this.pop();
        StateObject lowerBoundStateObject = this.pop();
        StateObject firstStateObject = this.pop();
        BetweenExpressionStateObject stateObject = new BetweenExpressionStateObject(this.getParent(), firstStateObject, not, lowerBoundStateObject, upperBoundStateObject);
        this.add(stateObject);
    }

    @Override
    public T between(T lowerBoundExpression, T upperBoundExpression) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{lowerBoundExpression, upperBoundExpression});
        this.between(false);
        return (T)this;
    }

    @Override
    public T collectionPath(String path) {
        StateObject stateObject = this.buildCollectionPath(path);
        this.add(stateObject);
        return (T)this;
    }

    protected void comparison(String identifier) {
        this.comparison(identifier, this.pop());
    }

    protected void comparison(String identifier, StateObject rightStateObject) {
        StateObject leftStateObject = this.pop();
        ComparisonExpressionStateObject stateObject = new ComparisonExpressionStateObject(this.getParent(), leftStateObject, identifier, rightStateObject);
        this.add(stateObject);
    }

    @Override
    public T different(Number number) {
        this.comparison("<>", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T different(String literal) {
        this.comparison("<>", this.literal(literal));
        return (T)this;
    }

    @Override
    public T different(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison("<>");
        return (T)this;
    }

    @Override
    public T equal(Number number) {
        this.comparison("=", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T equal(String literal) {
        this.comparison("=", this.literal(literal));
        return (T)this;
    }

    @Override
    public T equal(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison("=");
        return (T)this;
    }

    protected void exists(boolean not, SimpleSelectStatementStateObject subquery) {
        ExistsExpressionStateObject stateObject = new ExistsExpressionStateObject(this.getParent(), not, subquery);
        this.add(stateObject);
    }

    @Override
    public T exists(SimpleSelectStatementStateObject subquery) {
        this.exists(false, subquery);
        return (T)this;
    }

    @Override
    public T FALSE() {
        this.keyword("FALSE");
        return (T)this;
    }

    @Override
    public T greaterThan(Number number) {
        this.comparison(">", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T greaterThan(String literal) {
        this.comparison(">", this.literal(literal));
        return (T)this;
    }

    @Override
    public T greaterThan(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison(">");
        return (T)this;
    }

    @Override
    public T greaterThanOrEqual(Number number) {
        this.comparison(">=", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T greaterThanOrEqual(String literal) {
        this.comparison(">=", this.literal(literal));
        return (T)this;
    }

    @Override
    public T greaterThanOrEqual(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison(">=");
        return (T)this;
    }

    @Override
    protected void in(boolean not, List<StateObject> inItems) {
        StateObject stateFieldPath = this.pop();
        InExpressionStateObject stateObject = new InExpressionStateObject(this.getParent(), stateFieldPath, not, inItems);
        this.add(stateObject);
    }

    @Override
    protected void in(boolean not, String ... inItems) {
        this.in((T)not, (T)this.literals(inItems));
    }

    @Override
    protected void in(boolean not, T ... inItems) {
        this.in((T)false, (T)this.stateObjects((IScalarExpressionStateObjectBuilder[])inItems));
    }

    @Override
    public T in(SimpleSelectStatementStateObject subquery) {
        this.in((T)false, (T)Collections.singletonList(subquery));
        return (T)this;
    }

    @Override
    public T in(String ... inItems) {
        this.in(false, inItems);
        return (T)this;
    }

    @Override
    public T in(T builder) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{builder});
        this.in((T)false, (T)new IAbstractConditionalExpressionStateObjectBuilder[]{builder});
        return (T)this;
    }

    @Override
    public T in(T builder1, T builder2) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{builder1, builder2});
        this.in((T)false, (T)new IAbstractConditionalExpressionStateObjectBuilder[]{builder1, builder2});
        return (T)this;
    }

    protected void isEmpty(boolean not, String path) {
        EmptyCollectionComparisonExpressionStateObject stateObject = new EmptyCollectionComparisonExpressionStateObject(this.getParent(), not, path);
        this.add(stateObject);
    }

    @Override
    public T isEmpty(String path) {
        this.isEmpty(false, path);
        return (T)this;
    }

    @Override
    public T isNotEmpty(String path) {
        this.isEmpty(true, path);
        return (T)this;
    }

    @Override
    public T isNotNull(String path) {
        this.isNull(true, path);
        return (T)this;
    }

    protected void isNull(boolean not, String path) {
        StateObject stateObject = ExpressionTools.isParameter(path.charAt(0)) ? this.buildInputParameter(path) : this.buildStateFieldPath(path);
        stateObject = new NullComparisonExpressionStateObject(this.getParent(), not, stateObject);
        this.add(stateObject);
    }

    @Override
    public T isNull(String path) {
        this.isNull(false, path);
        return (T)this;
    }

    protected void keyword(String identifier) {
        KeywordExpressionStateObject stateObject = new KeywordExpressionStateObject(this.getParent(), identifier);
        this.add(stateObject);
    }

    @Override
    protected void like(boolean not, String escapeCharacter) {
        StateObject patternValue = this.pop();
        StateObject string = this.pop();
        LikeExpressionStateObject stateObject = new LikeExpressionStateObject(this.getParent(), string, not, patternValue, escapeCharacter);
        this.add(stateObject);
    }

    @Override
    public T like(String patternValue) {
        this.like((T)((IAbstractConditionalExpressionStateObjectBuilder)this.string(patternValue)));
        return (T)this;
    }

    @Override
    public T like(T patternValue) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)patternValue);
        this.like(false, (String)null);
        return (T)this;
    }

    @Override
    public T like(T patternValue, String escapeCharacter) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)patternValue);
        this.like(false, escapeCharacter);
        return (T)this;
    }

    @Override
    public T lower(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        LowerExpressionStateObject stateObject = new LowerExpressionStateObject(this.getParent(), this.pop());
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T lowerThan(Number number) {
        this.comparison("<", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T lowerThan(String literal) {
        this.comparison("<", this.literal(literal));
        return (T)this;
    }

    @Override
    public T lowerThan(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison("<");
        return (T)this;
    }

    @Override
    public T lowerThanOrEqual(Number number) {
        this.comparison("<=", this.buildNumeric(number));
        return (T)this;
    }

    @Override
    public T lowerThanOrEqual(String literal) {
        this.comparison("<=", this.literal(literal));
        return (T)this;
    }

    @Override
    public T lowerThanOrEqual(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.comparison("<=");
        return (T)this;
    }

    protected void member(boolean not, boolean of, String collectionValuedPathExpression) {
        StateObject entity = this.pop();
        CollectionMemberExpressionStateObject stateObject = new CollectionMemberExpressionStateObject(this.getParent(), entity, not, of, collectionValuedPathExpression);
        this.add(stateObject);
    }

    @Override
    public T member(String path) {
        this.member(false, false, path);
        return (T)this;
    }

    @Override
    public T memberOf(String path) {
        this.member(false, true, path);
        return (T)this;
    }

    @Override
    public T notBetween(T lowerBoundExpression, T upperBoundExpression) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{lowerBoundExpression, upperBoundExpression});
        this.between(true);
        return (T)this;
    }

    @Override
    public T notExists(SimpleSelectStatementStateObject subquery) {
        this.exists(true, subquery);
        return (T)this;
    }

    @Override
    public T notIn(SimpleSelectStatementStateObject subquery) {
        this.in((T)true, (T)Collections.singletonList(subquery));
        return (T)this;
    }

    @Override
    public T notIn(String ... inItems) {
        this.in(true, inItems);
        return (T)this;
    }

    @Override
    public T notIn(T builder) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{builder});
        this.in((T)true, (T)new IAbstractConditionalExpressionStateObjectBuilder[]{builder});
        return (T)this;
    }

    @Override
    public T notIn(T builder1, T builder2) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{builder1, builder2});
        this.in((T)true, (T)new IAbstractConditionalExpressionStateObjectBuilder[]{builder1, builder2});
        return (T)this;
    }

    @Override
    public T notLike(String patternValue) {
        this.notLike((T)((IAbstractConditionalExpressionStateObjectBuilder)this.string(patternValue)));
        return (T)this;
    }

    @Override
    public T notLike(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.like(true, (String)null);
        return (T)this;
    }

    @Override
    public T notLike(T builder, String escapeCharacter) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        this.like(true, escapeCharacter);
        return (T)this;
    }

    @Override
    public T notMember(String path) {
        this.member(true, false, path);
        return (T)this;
    }

    @Override
    public T notMemberOf(String path) {
        this.member(true, true, path);
        return (T)this;
    }

    @Override
    public T NULL() {
        this.keyword("NULL");
        return (T)this;
    }

    @Override
    public T or(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        StateObject rightStateObject = this.pop();
        StateObject leftStateObject = this.pop();
        OrExpressionStateObject stateObject = new OrExpressionStateObject(this.getParent(), leftStateObject, rightStateObject);
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T some(SimpleSelectStatementStateObject subquery) {
        this.allOrAny("SOME", subquery);
        return (T)this;
    }

    @Override
    public T sub(StateObject stateObject) {
        stateObject = new SubExpressionStateObject(this.getParent(), stateObject);
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T substring(T parameter1, T parameter2, T parameter3) {
        this.checkBuilders(new IAbstractConditionalExpressionStateObjectBuilder[]{parameter1, parameter2, parameter3});
        StateObject thirdStateObject = this.pop();
        StateObject secondStateObject = this.pop();
        StateObject firstStateObject = this.pop();
        SubstringExpressionStateObject stateObject = new SubstringExpressionStateObject(this.getParent(), firstStateObject, secondStateObject, thirdStateObject);
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T trim(TrimExpression.Specification specification, String trimCharacter, T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        StateObject stateObject = this.pop();
        stateObject = new TrimExpressionStateObject(this.getParent(), specification, ExpressionTools.stringIsNotEmpty(trimCharacter) ? this.literal(trimCharacter) : null, stateObject);
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T trim(TrimExpression.Specification specification, T builder) {
        return this.trim(specification, null, builder);
    }

    @Override
    public T TRUE() {
        this.keyword("TRUE");
        return (T)this;
    }

    @Override
    public T upper(T builder) {
        this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        UpperExpressionStateObject stateObject = new UpperExpressionStateObject(this.getParent(), this.pop());
        this.add(stateObject);
        return (T)this;
    }

    @Override
    public T variable(String variable) {
        StateObject stateObject = this.buildIdentificationVariable(variable);
        this.add(stateObject);
        return (T)this;
    }
}

