/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.BlendingLens;

public class BGaussianLens
extends BlendingLens {
    protected double aT = 0.0;
    protected double bT = 0.0;
    protected double cT = 0.0;
    protected double eT = 0.0;

    public BGaussianLens() {
        this(2.0f, 0.0f, 1.0f, 100, 50, 0, 0);
    }

    public BGaussianLens(float mm) {
        this(mm, 0.0f, 1.0f, 100, 50, 0, 0);
    }

    public BGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        this(2.0f, tc, tf, outerRadius, innerRadius, 0, 0);
    }

    public BGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
        this.lx = x;
        this.ly = y;
    }

    @Override
    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.computeDropoffFactors();
    }

    @Override
    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.computeDropoffFactors();
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    @Override
    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    void computeDropoffFactors() {
        this.aT = Math.PI / (double)(this.LR1 - this.LR2);
        this.bT = -Math.PI * (double)this.LR2 / (double)(this.LR1 - this.LR2);
        this.cT = (this.MMTf - this.MMTc) / 2.0f;
        this.eT = (this.MMTf + this.MMTc) / 2.0f;
    }

    @Override
    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : (this.d <= (double)this.LR1 ? (float)(this.cT * Math.cos(this.aT * this.d + this.bT) + this.eT) : 0.0f);
    }
}

