/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.DebugTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.DeveloperTuningTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.ExpertTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.OverviewTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.SupervisorTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.SymbexRuntimeTab;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.TestGenerationTab;

public class LaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private AbstractConfigurationPage[] fConfigurationPages;
    protected OverviewTab fOverviewTab;
    protected ExpertTab fExpertTab;

    public AbstractConfigurationPage[] getConfigurationPages() {
        return this.fConfigurationPages;
    }

    public OverviewTab getOverviewTab() {
        return this.fOverviewTab;
    }

    public ExpertTab getExpertTab() {
        return this.fExpertTab;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ArrayList<Object> tabList = new ArrayList<Object>();
        ArrayList<AbstractConfigurationPage> confPageList = new ArrayList<AbstractConfigurationPage>();
        this.fOverviewTab = new OverviewTab(this);
        tabList.add((Object)this.fOverviewTab);
        confPageList.add(this.fOverviewTab.getConfigurationPage());
        SupervisorTab supervisorTab = new SupervisorTab(this);
        tabList.add((Object)supervisorTab);
        confPageList.add(supervisorTab.getConfigurationPage());
        TestGenerationTab testGenerationTab = new TestGenerationTab(this);
        tabList.add((Object)testGenerationTab);
        confPageList.add(testGenerationTab.getConfigurationPage());
        if ("debug".equals(mode)) {
            if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_DEBUG_OPTIONS")) {
                tabList.add((Object)new DebugTab(this));
            }
            if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_EXPERT_MODE")) {
                this.fExpertTab = new ExpertTab(this);
                tabList.add((Object)this.fExpertTab);
                confPageList.add(this.fExpertTab.getConfigurationPage());
            }
            if (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SYMBEX_DEVELOPER_MODE")) {
                tabList.add((Object)new DeveloperTuningTab(this));
            }
        }
        tabList.add(new RefreshTab());
        if ("debug".equals(mode)) {
            tabList.add((Object)new SymbexRuntimeTab());
        }
        tabList.add(new CommonTab());
        this.setTabs(tabList.toArray(new ILaunchConfigurationTab[tabList.size()]));
        this.fConfigurationPages = confPageList.toArray(new AbstractConfigurationPage[confPageList.size()]);
    }

    public void setDefaultAttributes(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String refreshScope = configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "");
            if (refreshScope == null || refreshScope.isEmpty()) {
                configuration.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "${project}");
            }
        }
        catch (CoreException coreException) {
            configuration.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "${project}");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        this.setDefaultAttributes(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.setDefaultAttributes(configuration);
    }
}

