/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.Joiner;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.data.KeywordColor;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ImportExportUtils {
    private static final String KEYWORD_ELEMENT_KEY = "keyword";
    private static final String COLOR_ELEMENT_KEY = "color";
    private static final String VERSION_ATTRIBUTE_KEY = "version";
    private static final String CURRENT_LV_VERSION = "1.3";
    private static final String VALUE_ELEMENT_KEY = "value";
    private static final String NEW_LINE = "\n";
    private static final String PARENT_INDENTATION = "   ";
    private static final String CHILD_INDENTATION = "      ";
    private static final String COLOR_CHILD_INDENTATION = "         ";
    private static final String XML_EXTENSION_MASK = "*.xml";
    private static final String XML_EXTENSION = ".xml";

    private ImportExportUtils() {
    }

    public static String arrayToString(String[] array, String delimiter) {
        return new Joiner(delimiter).join(Arrays.asList(array)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportSettings(String pageID, Map<String, String[]> settings, boolean useIndentation) {
        FileOutputStream stream = null;
        try {
            stream = ImportExportUtils.createOutputStream();
            if (stream != null) {
                ImportExportUtils.exportToXml(pageID, settings, useIndentation, stream);
            }
        }
        catch (TechnicalException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    private static FileOutputStream createOutputStream() throws TechnicalException {
        String resultFile = ImportExportUtils.getTargetFileFromWithDialog();
        if (resultFile == null || resultFile.compareTo(File.separator) == 0) {
            return null;
        }
        resultFile = ImportExportUtils.addXmlExtension(resultFile);
        File file = new File(resultFile);
        PreferencesHandler.getInstance().setExportLastDir(file.getParentFile().getPath());
        try {
            file.createNewFile();
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new TechnicalException("Cannot open file: " + file.getAbsolutePath());
        }
    }

    private static String addXmlExtension(String resultFile) {
        if (!resultFile.endsWith(XML_EXTENSION)) {
            return resultFile.concat(XML_EXTENSION);
        }
        return resultFile;
    }

    private static String getTargetFileFromWithDialog() {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        FileDialog dialog = new FileDialog(shell, 8192);
        String exportLastDir = PreferencesHandler.getInstance().getExportLastDir();
        boolean pathValid = new Path(exportLastDir).isValidPath(exportLastDir);
        if (!exportLastDir.isEmpty() && pathValid) {
            dialog.setFilterPath(exportLastDir);
        }
        dialog.setFilterExtensions(new String[]{XML_EXTENSION_MASK});
        dialog.setText(Messages.getString("ImportExportUtils.0"));
        String dialogResult = dialog.open();
        if (dialogResult == null) {
            return null;
        }
        return dialog.getFilterPath() + File.separator + dialog.getFileName();
    }

    protected static void exportToXml(String pageID, Map<String, String[]> settings, boolean useIndentation, OutputStream stream) throws TechnicalException {
        try {
            Document document = ImportExportUtils.createDocument(pageID);
            Element root = document.getDocumentElement();
            root.setAttribute(VERSION_ATTRIBUTE_KEY, CURRENT_LV_VERSION);
            TreeMap<String, String[]> sortedMap = new TreeMap<String, String[]>(settings);
            for (Map.Entry entry : sortedMap.entrySet()) {
                String currentKey = (String)entry.getKey();
                Object[] values = (String[])entry.getValue();
                Element parent = document.createElement(currentKey);
                if (useIndentation) {
                    root.appendChild(document.createTextNode("\n   "));
                }
                root.appendChild(parent);
                for (int i = 0; i < values.length; ++i) {
                    ImportExportUtils.addStringElement(useIndentation, document, parent, values[i]);
                    ImportExportUtils.addNewLineIfLast(document, parent, values, i);
                }
            }
            if (useIndentation) {
                root.appendChild(document.createTextNode(NEW_LINE));
            }
            ImportExportUtils.writeDocument(stream, document);
        }
        catch (ParserConfigurationException e) {
            throw new TechnicalException(e);
        }
        catch (TransformerException e) {
            throw new TechnicalException(e);
        }
    }

    private static Document createDocument(String pageID) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation implementation = builder.getDOMImplementation();
        return implementation.createDocument(null, pageID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportColorSettings(String pageID, Map<String, Object[]> settings, boolean useIndentation) {
        FileOutputStream stream = null;
        try {
            stream = ImportExportUtils.createOutputStream();
            if (stream != null) {
                ImportExportUtils.exportKeywordColorsToXml(pageID, settings, useIndentation, stream);
            }
        }
        catch (TechnicalException e) {
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("LogViewerPreferenceRootPage.2") + e));
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    protected static void exportKeywordColorsToXml(String pageID, Map<String, Object[]> settings, boolean useIndentation, OutputStream stream) throws TechnicalException {
        try {
            Document document = ImportExportUtils.createDocument(pageID);
            Element root = document.getDocumentElement();
            root.setAttribute(VERSION_ATTRIBUTE_KEY, CURRENT_LV_VERSION);
            TreeMap<String, Object[]> sortedMap = new TreeMap<String, Object[]>(settings);
            for (Map.Entry entry : sortedMap.entrySet()) {
                int i;
                String currentKey = (String)entry.getKey();
                Element parent = document.createElement(currentKey);
                if (useIndentation) {
                    root.appendChild(document.createTextNode("\n   "));
                }
                root.appendChild(parent);
                Object[] values = (Object[])entry.getValue();
                if (values instanceof String[]) {
                    String[] stringValues = (String[])values;
                    for (i = 0; i < stringValues.length; ++i) {
                        ImportExportUtils.addStringElement(useIndentation, document, parent, stringValues[i]);
                        ImportExportUtils.addNewLineIfLast(document, parent, values, i);
                    }
                    continue;
                }
                if (!(values instanceof KeywordColor[])) continue;
                KeywordColor[] colorValues = (KeywordColor[])values;
                for (i = 0; i < colorValues.length; ++i) {
                    ImportExportUtils.addKeywordColor(useIndentation, document, parent, colorValues[i]);
                    ImportExportUtils.addNewLineIfLast(document, parent, values, i);
                }
            }
            if (useIndentation) {
                root.appendChild(document.createTextNode(NEW_LINE));
            }
            ImportExportUtils.writeDocument(stream, document);
        }
        catch (ParserConfigurationException e) {
            throw new TechnicalException(e);
        }
        catch (TransformerException e) {
            throw new TechnicalException(e);
        }
    }

    private static void addNewLineIfLast(Document document, Element parent, Object[] values, int i) {
        if (i == values.length - 1) {
            parent.appendChild(document.createTextNode("\n   "));
        }
    }

    private static void addKeywordColor(boolean useIndentation, Document document, Element parent, KeywordColor keywordColor) {
        Element child = document.createElement(VALUE_ELEMENT_KEY);
        if (useIndentation) {
            parent.appendChild(document.createTextNode("\n      "));
        }
        parent.appendChild(child);
        Element keywordChild = document.createElement(KEYWORD_ELEMENT_KEY);
        keywordChild.setTextContent(keywordColor.getKeyword());
        if (useIndentation) {
            child.appendChild(document.createTextNode("\n         "));
        }
        child.appendChild(keywordChild);
        Element colorChild = document.createElement(COLOR_ELEMENT_KEY);
        if (keywordColor.getColor() != null) {
            String color = keywordColor.getColor().red + "," + keywordColor.getColor().green + "," + keywordColor.getColor().blue;
            colorChild.setTextContent(color);
        } else {
            colorChild.setTextContent("");
        }
        if (useIndentation) {
            child.appendChild(document.createTextNode("\n         "));
        }
        child.appendChild(colorChild);
        child.appendChild(document.createTextNode("\n      "));
    }

    private static void addStringElement(boolean useIndentation, Document document, Element parent, String stringValue) {
        Element child = document.createElement(VALUE_ELEMENT_KEY);
        child.setTextContent(stringValue);
        if (useIndentation) {
            parent.appendChild(document.createTextNode("\n      "));
        }
        parent.appendChild(child);
    }

    private static void writeDocument(OutputStream stream, Document document) throws TransformerException {
        DOMSource input = new DOMSource(document);
        StreamResult output = new StreamResult(stream);
        TransformerFactory xFormFactory = TransformerFactory.newInstance();
        Transformer idTransform = xFormFactory.newTransformer();
        idTransform.transform(input, output);
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> importSettings(String pageID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static Map<String, String> importFromStream(String pageID, InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        InputSource inputSource = new InputSource(stream);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(inputSource);
        Element documentElement = document.getDocumentElement();
        if (!documentElement.getNodeName().contentEquals(pageID)) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)Messages.getString("ImportExportUtils.2"), (String)Messages.getString("ImportExportUtils.3"));
                }
            });
            return null;
        }
        String version = documentElement.getAttribute(VERSION_ATTRIBUTE_KEY);
        if (version.contentEquals(CURRENT_LV_VERSION)) {
            return ImportExportUtils.importNewSettings(documentElement);
        }
        return ImportExportUtils.importOldSettings(pageID, documentElement);
    }

    public static String getImportSourceFileWithDialog() {
        String dialogResult;
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{XML_EXTENSION_MASK});
        dialog.setText(Messages.getString("ImportExportUtils.1"));
        String importLastDir = PreferencesHandler.getInstance().getImportLastDir();
        boolean pathValid = new Path(importLastDir).isValidPath(importLastDir);
        if (!StringUtils.isNullOrEmpty((String)importLastDir) && pathValid) {
            dialog.setFilterPath(importLastDir);
        }
        if ((dialogResult = dialog.open()) == null || StringUtils.isNullOrEmpty((String)dialog.getFileName())) {
            return null;
        }
        return dialog.getFilterPath() + File.separator + dialog.getFileName();
    }

    private static Map<String, String> importNewSettings(Element documentElement) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList parents = documentElement.getChildNodes();
        for (int i = 0; i < parents.getLength(); ++i) {
            Node currentNode = parents.item(i);
            NodeList values = currentNode.getChildNodes();
            for (int j = 0; j < values.getLength(); ++j) {
                Node currentValue = values.item(j);
                if (!currentValue.getNodeName().contentEquals(VALUE_ELEMENT_KEY)) continue;
                ImportExportUtils.importValueElement(result, currentNode, currentValue);
            }
        }
        return result;
    }

    private static void importValueElement(Map<String, String> result, Node currentNode, Node currentValue) {
        String fetchedValue;
        String storedValue = result.get(currentNode.getNodeName());
        NodeList keywords = currentValue.getChildNodes();
        if (keywords.getLength() > 1) {
            StringBuilder keywordColor = new StringBuilder();
            for (int k = 0; k < keywords.getLength(); ++k) {
                Node currentKeyword = keywords.item(k);
                if (currentKeyword.getNodeName().contentEquals(KEYWORD_ELEMENT_KEY)) {
                    keywordColor.append(currentKeyword.getTextContent());
                }
                if (!currentKeyword.getNodeName().contentEquals(COLOR_ELEMENT_KEY)) continue;
                keywordColor.append("#" + currentKeyword.getTextContent());
            }
            fetchedValue = keywordColor.toString();
        } else {
            fetchedValue = currentValue.getTextContent();
        }
        if (storedValue != null && !storedValue.contentEquals("")) {
            result.put(currentNode.getNodeName(), storedValue.concat(File.pathSeparator.concat(fetchedValue)));
        } else {
            result.put(currentNode.getNodeName(), fetchedValue);
        }
    }

    private static Map<String, String> importOldSettings(String pageID, Element documentElement) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList childNodes = documentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName = childNodes.item(i).getNodeName();
            if (nodeName.compareTo(pageID) != 0) continue;
            Element e = (Element)childNodes.item(i);
            NamedNodeMap attributes = e.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                result.put(attributes.item(j).getNodeName(), attributes.item(j).getNodeValue());
            }
        }
        return result;
    }
}

