/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titanium.markers.export.ExportedProblemMerger;

public class MergeExportedMarkerTables
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length == 0) {
            System.out.println("Valid options: file_name(s).xls [-o filename]");
            return -1;
        }
        LinkedList<File> files = new LinkedList<File>();
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].endsWith(".xls")) {
                File file = new File(args[i]);
                files.add(file);
                continue;
            }
            if ("-o".equals(args[i])) {
                if (++i < args.length) {
                    name = args[i];
                    continue;
                }
                System.out.println("File name required after -o");
                return -1;
            }
            System.out.println("Valid options: file_name(s).xls [-o filename]");
            return -1;
        }
        boolean result = this.merge(files, name);
        if (result) {
            return EXIT_OK;
        }
        return -1;
    }

    public void stop() {
    }

    private boolean merge(List<File> files, String outfileName) {
        File outfile = null;
        outfile = outfileName != null ? new File(outfileName + ".xls") : new File("Summary.xls");
        int counter = 1;
        while (outfile.exists()) {
            outfile = outfileName != null ? new File(outfileName + counter + ".xls") : new File("Summary" + counter + ".xls");
            ++counter;
        }
        ExportedProblemMerger epm = new ExportedProblemMerger(files, outfile);
        return epm.run();
    }
}

