/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class PrintingType
extends ASTNode
implements ILocateableNode {
    private final PrintingTypeEnum printingType;
    private CompilationTimeStamp lastTimeChecked;
    private Location location;

    public PrintingType(PrintingTypeEnum printingType) {
        this.printingType = printingType;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        builder.append(".<printing>");
        return builder;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return PrintingTypeEnum.NONE != this.printingType;
    }

    public static enum PrintingTypeEnum {
        NONE,
        COMPACT,
        PRETTY;

    }
}

