/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Def_Var_Template
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<initial_value>";
    public static final String PORTNOTALLOWED = "Template variable can not be defined for port type `{0}''";
    private static final String KIND = " template variable definition";
    private final Type type;
    private final TTCN3Template initialValue;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private boolean wasAssigned;

    public Def_Var_Template(TemplateRestriction.Restriction_type templateRestriction, Identifier identifier, Type type, TTCN3Template initialValue) {
        super(identifier);
        this.templateRestriction = templateRestriction;
        this.type = type;
        this.initialValue = initialValue;
        if (type != null) {
            type.setFullNameParent(this);
        }
        if (initialValue != null) {
            initialValue.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_VAR_TEMPLATE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.initialValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public String getAssignmentName() {
        return "template variable";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "template_dynamic.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.initialValue != null) {
            this.initialValue.setMyScope(scope);
        }
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.wasAssigned = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalVariableTemplate", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.type.check(timestamp);
        this.lastTimeChecked = timestamp;
        if (this.initialValue == null) {
            return;
        }
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
        }
        TTCN3Template realInitialValue = this.initialValue;
        this.initialValue.setMyGovernor(this.type);
        if (this.initialValue.getTemplatetype() == ITTCN3Template.Template_type.CSTR_PATTERN && lastType.getTypetype() == IType.Type_type.TYPE_UCHARSTRING) {
            realInitialValue = this.initialValue.setTemplatetype(timestamp, ITTCN3Template.Template_type.USTR_PATTERN);
        }
        ITTCN3Template temporalValue = this.type.checkThisTemplateRef(timestamp, realInitialValue);
        temporalValue.checkThisTemplateGeneric(timestamp, this.type, true, true, true, true, false);
        TemplateRestriction.check(timestamp, this, this.initialValue, null);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        if (!this.wasAssigned) {
            this.location.reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportReadOnly", "warning", null), MessageFormat.format("The {0} seems to be never written, maybe it could be a template", this.getDescription()));
        }
    }

    public TTCN3Template getInitialValue() {
        return this.initialValue;
    }

    public void setWritten() {
        this.wasAssigned = true;
    }

    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_VAR_TEMPLATE.equals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a template variable, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Var_Template otherVariable = (Def_Var_Template)definition;
        if (!this.type.isIdentical(timestamp, otherVariable.type)) {
            String message = MessageFormat.format("Local template variable `{0}'' has type `{1}'', but the template variable inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.type.getTypename(), otherVariable.getMyScope().getFullName(), otherVariable.type.getTypename());
            this.type.getLocation().reportSemanticError(message);
            return false;
        }
        if (this.initialValue != null) {
            if (otherVariable.initialValue == null) {
                this.initialValue.getLocation().reportSemanticWarning(MessageFormat.format("Local template variable `{0}'' has initial value, but the template variable inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
            }
        } else if (otherVariable.initialValue != null) {
            this.location.reportSemanticWarning(MessageFormat.format("Local template variable `{0}'' does not have initial value, but the template variable inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
        }
        return true;
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            super.addProposal(propCollector, i);
        }
        if (subrefs.size() > i + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.type.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.initialValue == null) {
            result.add(218);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.initialValue != null) {
                if (enveloped) {
                    this.initialValue.updateSyntax(reparser, false);
                    reparser.updateLocation(this.initialValue.getLocation());
                } else if (reparser.envelopsDamage(this.initialValue.getLocation())) {
                    this.initialValue.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.initialValue.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.initialValue != null) {
            this.initialValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.initialValue.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.initialValue != null) {
            this.initialValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.initialValue == null || this.initialValue.accept(v);
    }

    public boolean getWritten() {
        return this.wasAssigned;
    }
}

