/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArguments;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Verdict_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Setverdict_Statement
extends Statement {
    private static final String OPERANDERROR = "The operand of the `setverdict' operation should be a verdict value";
    private static final String INCONTROLPART = "Setverdict statement is not allowed in the control part";
    private static final String ERRORCANNOTBESET = "Error verdict cannot be set by the setverdict operation";
    private static final String WITHOUT_REASON = "{0} verdict should not be set without telling the reason";
    private static final String FULLNAMEPART1 = ".verdictvalue";
    private static final String FULLNAMEPART2 = ".verdictreason";
    private static final String STATEMENT_NAME = "setverdict";
    private final Value verdictValue;
    private LogArguments verdictReason;
    private static String reportSetverdictWithoutReason;

    public Setverdict_Statement(Value verdictValue, LogArguments verdictReason) {
        this.verdictValue = verdictValue;
        this.verdictReason = verdictReason;
        if (verdictValue != null) {
            verdictValue.setFullNameParent(this);
        }
        if (verdictReason != null) {
            this.verdictReason.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SETVERDICT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.verdictValue == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.verdictReason == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.verdictValue != null) {
            this.verdictValue.setMyScope(scope);
        }
        if (this.verdictReason != null) {
            this.verdictReason.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.myStatementBlock.getMyDefinition() == null) {
            this.location.reportSemanticError(INCONTROLPART);
        }
        if (this.verdictValue != null) {
            this.verdictValue.setLoweridToReference(timestamp);
            IType.Type_type temp = this.verdictValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temp) {
                case TYPE_VERDICT: {
                    IValue last = this.verdictValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (IValue.Value_type.VERDICT_VALUE.equals((Object)last.getValuetype()) && Verdict_Value.Verdict_type.ERROR.equals((Object)((Verdict_Value)last).getValue())) {
                        this.getLocation().reportSemanticError(ERRORCANNOTBESET);
                    }
                    if (!IValue.Value_type.VERDICT_VALUE.equals((Object)last.getValuetype()) || Verdict_Value.Verdict_type.PASS.equals((Object)((Verdict_Value)last).getValue()) || this.verdictReason != null) break;
                    this.getLocation().reportConfigurableSemanticProblem(reportSetverdictWithoutReason, MessageFormat.format(WITHOUT_REASON, new Object[]{((Verdict_Value)last).getValue()}));
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR);
                    this.verdictValue.setIsErroneous(true);
                }
            }
        }
        if (this.verdictReason != null) {
            this.verdictReason.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.verdictValue != null) {
            this.verdictValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.verdictValue.getLocation());
        }
        if (this.verdictReason != null) {
            this.verdictReason.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.verdictValue != null) {
            this.verdictValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.verdictReason != null) {
            this.verdictReason.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.verdictValue != null && !this.verdictValue.accept(v)) {
            return false;
        }
        return this.verdictReason == null || this.verdictReason.accept(v);
    }

    public Value getVerdictValue() {
        return this.verdictValue;
    }

    public LogArguments getVerdictReason() {
        return this.verdictReason;
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            reportSetverdictWithoutReason = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportSetverdictWithoutReason", "ignore", null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportSetverdictWithoutReason".equals(property)) {
                            reportSetverdictWithoutReason = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportSetverdictWithoutReason", "ignore", null);
                        }
                    }
                });
            }
        }
    }
}

