/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueList_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueRange;
import org.eclipse.titan.designer.AST.TTCN3.templates.Value_Range_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Integer_Type
extends Type {
    public static final String INTEGERVALUEEXPECTED = "integer value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `integer''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `integer''";
    private static final String INCORRECTBOUNDARIES = "The lower boundary is higher than the upper boundary";
    private static final String INCORRECTLOWERBOUNDARY = "The lower boundary cannot be +infinity";
    private static final String INCORRECTUPPERBOUNDARY = "The upper boundary cannot be -infinity";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_INTEGER.equals((Object)temp.getTypetype()) || IType.Type_type.TYPE_INTEGER_A.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "integer";
    }

    @Override
    public String getOutlineIcon() {
        return "integer.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_INTEGER;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.parseAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    public void checkThisValueLimit(CompilationTimeStamp timestamp, IValue value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean omitAllowed, boolean subCheck, boolean implicitOmit) {
        super.checkThisValue(timestamp, value, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, omitAllowed, subCheck, implicitOmit, false));
        IValue last = value.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                break;
            }
            case REAL_VALUE: {
                Real_Value real = (Real_Value)last;
                if (real.isNegativeInfinity() || real.isPositiveInfinity()) break;
                value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
                value.setIsErroneous(true);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        if (subCheck && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        switch (template.getTemplatetype()) {
            case VALUE_RANGE: {
                ValueRange range = ((Value_Range_Template)template).getValueRange();
                IValue lower = this.checkBoundary(timestamp, range.getMin(), BOUNDARY_TYPE.LOWER);
                IValue upper = this.checkBoundary(timestamp, range.getMax(), BOUNDARY_TYPE.UPPER);
                if (lower == null || !IValue.Value_type.INTEGER_VALUE.equals((Object)lower.getValuetype()) || upper == null || !IValue.Value_type.INTEGER_VALUE.equals((Object)upper.getValuetype()) || this.getIsErroneous(timestamp) || ((Integer_Value)lower).getValue() <= ((Integer_Value)upper).getValue()) break;
                template.getLocation().reportSemanticError(INCORRECTBOUNDARIES);
                template.setIsErroneous(true);
                break;
            }
            case VALUE_LIST: {
                ValueList_Template temp = (ValueList_Template)template;
                for (int i = 0; i < temp.getNofTemplates(); ++i) {
                    TTCN3Template tmp = temp.getTemplateByIndex(i).getTemplate();
                    this.checkThisTemplate(timestamp, tmp, isModified, implicitOmit);
                }
                break;
            }
            case ANY_OR_OMIT: 
            case ANY_VALUE: {
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
                template.setIsErroneous(true);
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
            template.setIsErroneous(true);
        }
    }

    private IValue checkBoundary(CompilationTimeStamp timestamp, Value value, BOUNDARY_TYPE btype) {
        if (value == null) {
            return null;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValueLimit(timestamp, temp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false);
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (IValue.Value_type.REAL_VALUE.equals((Object)temp.getValuetype())) {
            if (((Real_Value)temp).isNegativeInfinity()) {
                if (BOUNDARY_TYPE.UPPER.equals((Object)btype)) {
                    value.getLocation().reportSemanticError(INCORRECTUPPERBOUNDARY);
                    value.setIsErroneous(true);
                }
                return temp;
            }
            if (((Real_Value)temp).isPositiveInfinity()) {
                if (BOUNDARY_TYPE.LOWER.equals((Object)btype)) {
                    value.getLocation().reportSemanticError(INCORRECTLOWERBOUNDARY);
                    value.setIsErroneous(true);
                }
                return temp;
            }
            value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
            value.setIsErroneous(true);
            return null;
        }
        switch (temp.getValuetype()) {
            case INTEGER_VALUE: {
                break;
            }
            default: {
                temp = null;
            }
        }
        return temp;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("integer");
    }

    private static enum BOUNDARY_TYPE {
        LOWER,
        UPPER;

    }
}

