/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SignatureFormalParameterList
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<unknown_parameter>";
    private final List<SignatureFormalParameter> parameters;
    private final Map<String, SignatureFormalParameter> parameterMap;
    private List<SignatureFormalParameter> inParameters;
    private List<SignatureFormalParameter> outParameters;
    private CompilationTimeStamp lastTimeChecked;
    private Location location = NULL_Location.INSTANCE;

    public SignatureFormalParameterList(List<SignatureFormalParameter> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = null;
            this.parameterMap = null;
        } else {
            this.parameters = new ArrayList<SignatureFormalParameter>(parameters.size());
            this.parameterMap = new HashMap<String, SignatureFormalParameter>(parameters.size());
            this.inParameters = new ArrayList<SignatureFormalParameter>();
            this.outParameters = new ArrayList<SignatureFormalParameter>();
            for (SignatureFormalParameter parameter : parameters) {
                if (parameter == null || parameter.getIdentifier() == null) continue;
                this.parameters.add(parameter);
                parameter.setFullNameParent(this);
            }
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.parameters == null) {
            return builder;
        }
        for (SignatureFormalParameter parameter : this.parameters) {
            if (parameter != child) continue;
            Identifier identifier = parameter.getIdentifier();
            return builder.append(".").append(identifier != null ? identifier.getDisplayName() : FULLNAMEPART);
        }
        return builder;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.parameters == null) {
            return;
        }
        for (SignatureFormalParameter parameter : this.parameters) {
            parameter.setMyScope(scope);
        }
    }

    public int getNofParameters() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public SignatureFormalParameter getParameterByIndex(int index) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(index);
    }

    public boolean hasParameterWithName(String name) {
        if (this.parameterMap == null) {
            return false;
        }
        return this.parameterMap.containsKey(name);
    }

    public SignatureFormalParameter getParameterByName(String name) {
        if (this.parameterMap == null) {
            return null;
        }
        return this.parameterMap.get(name);
    }

    public int getNofInParameters() {
        if (this.inParameters == null) {
            return 0;
        }
        return this.inParameters.size();
    }

    public SignatureFormalParameter getInParameterByIndex(int index) {
        if (this.inParameters == null) {
            return null;
        }
        return this.inParameters.get(index);
    }

    public int getNofOutParameters() {
        if (this.outParameters == null) {
            return 0;
        }
        return this.outParameters.size();
    }

    public SignatureFormalParameter getOutParameterByIndex(int index) {
        if (this.outParameters == null) {
            return null;
        }
        return this.outParameters.get(index);
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.parameters == null) {
            return;
        }
        for (SignatureFormalParameter parameter : this.parameters) {
            if (parameter == null) continue;
            String parameterName = parameter.getIdentifier().getName();
            if (this.parameterMap.containsKey(parameterName)) {
                this.parameterMap.get(parameterName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate parameter with name `{0}'' was first declared here", parameter.getIdentifier().getDisplayName()));
                parameter.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate parameter with name `{0}'' was declared here again", parameter.getIdentifier().getDisplayName()));
                continue;
            }
            this.parameterMap.put(parameterName, parameter);
        }
    }

    public void check(CompilationTimeStamp timestamp, Signature_Type signature) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.parameters == null) {
            return;
        }
        this.parameterMap.clear();
        this.inParameters.clear();
        this.outParameters.clear();
        this.checkUniqueness(timestamp);
        boolean isNonblock = signature.isNonblocking();
        for (SignatureFormalParameter parameter : this.parameters) {
            if (parameter.getDirection() == 0) {
                this.inParameters.add(parameter);
            } else if (parameter.getDirection() == 1) {
                if (isNonblock) {
                    parameter.getLocation().reportSemanticError("A non-blocking signature cannot have `out' parameter");
                }
                this.outParameters.add(parameter);
            } else if (parameter.getDirection() == 2) {
                if (isNonblock) {
                    parameter.getLocation().reportSemanticError("A non-blocking signature cannot have `out' parameter");
                }
                this.inParameters.add(parameter);
                this.outParameters.add(parameter);
            }
            Type type = parameter.getType();
            type.setParentType(signature);
            type.check(timestamp);
            type.checkEmbedded(timestamp, type.getLocation(), false, "the type of a signature parameter");
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.parameters == null) {
            return;
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            SignatureFormalParameter parameter = this.parameters.get(i);
            parameter.updateSyntax(reparser, isDamaged);
            reparser.updateLocation(parameter.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.parameters != null) {
            for (SignatureFormalParameter sfp : this.parameters) {
                sfp.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.parameters != null) {
            for (SignatureFormalParameter sfp : this.parameters) {
                if (sfp.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

