/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.projection.BProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class VCircle<T>
extends ClosedShape {
    public BProjectedCoords[] pc;

    public VCircle() {
        this(0.0, 0.0, 0, 10.0, Color.WHITE, Color.BLACK, 1.0f);
    }

    public VCircle(double x, double y, int z, double d, Color c) {
        this(x, y, z, d, c, Color.BLACK, 1.0f);
    }

    public VCircle(double x, double y, int z, double d, Color c, Color bc) {
        this(x, y, z, d, c, bc, 1.0f);
    }

    public VCircle(double x, double y, int z, double d, Color c, Color bc, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = d;
        this.orient = 0.0;
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new BProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new BProjectedCoords();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoords[] ta = this.pc;
                this.pc = new BProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new BProjectedCoords();
            } else {
                System.err.println("VCircle:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new BProjectedCoords[1];
            this.pc[0] = new BProjectedCoords();
        } else {
            System.err.println("VCircle:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return this.alphaC == null && Math.sqrt((w - (double)this.pc[camIndex].cx) * (w - (double)this.pc[camIndex].cx) + (h - (double)this.pc[camIndex].cy) * (h - (double)this.pc[camIndex].cy)) <= (double)this.pc[camIndex].cr / 2.0 && Math.sqrt((double)(this.pc[camIndex].cx * this.pc[camIndex].cx) + (h - (double)this.pc[camIndex].cy) * (h - (double)this.pc[camIndex].cy)) <= (double)this.pc[camIndex].cr / 2.0 && Math.sqrt((w - (double)this.pc[camIndex].cx) * (w - (double)this.pc[camIndex].cx) + (double)(this.pc[camIndex].cy * this.pc[camIndex].cy)) <= (double)this.pc[camIndex].cr / 2.0 && Math.sqrt(this.pc[camIndex].cx * this.pc[camIndex].cx + this.pc[camIndex].cy * this.pc[camIndex].cy) <= (double)this.pc[camIndex].cr / 2.0;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return Math.sqrt((jpx - this.pc[camIndex].cx) * (jpx - this.pc[camIndex].cx) + (jpy - this.pc[camIndex].cy) * (jpy - this.pc[camIndex].cy)) <= (double)this.pc[camIndex].cr / 2.0;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt((this.vx - dvx) * (this.vx - dvx) + (this.vy - dvy) * (this.vy - dvy)) <= dvr + this.size / 2.0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cr = (int)Math.round(this.size * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcr = (int)Math.round(this.size * this.coef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            if (this.pc[i].cr >= 1) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
                        g.setStroke(stdS);
                    } else {
                        g.drawOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
                    }
                }
                g.setComposite(acO);
            } else {
                g.setColor(this.color);
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            }
        } else if (this.pc[i].cr >= 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr / 2, dy + this.pc[i].cy - this.pc[i].cr / 2, this.pc[i].cr, this.pc[i].cr);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            if (this.pc[i].lcr >= 1) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
                        g.setStroke(stdS);
                    } else {
                        g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
                    }
                }
                g.setComposite(acO);
            } else {
                g.setColor(this.color);
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            }
        } else if (this.pc[i].lcr >= 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr / 2, dy + this.pc[i].lcy - this.pc[i].lcr / 2, this.pc[i].lcr, this.pc[i].lcr);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Ellipse2D.Double(this.vx - this.size / 2.0, this.vy - this.size / 2.0, this.size, this.size);
    }

    @Override
    public Object clone() {
        VCircle<T> res = new VCircle<T>(this.vx, this.vy, this.vz, this.size, this.color, this.borderColor, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

