/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.lib.Repository;

public class ReflogViewContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ReflogInput) {
            ReflogInput input = (ReflogInput)inputElement;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Git git = new Git(input.repository);){
                    ReflogCommand command = git.reflog();
                    command.setRef(input.ref);
                    return command.call().toArray();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.logError("Error running reflog command", e);
            }
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public static class ReflogInput {
        private final Repository repository;
        private final String ref;

        public ReflogInput(Repository repository, String ref) {
            Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
            Assert.isNotNull((Object)ref, (String)"Ref cannot be null");
            this.repository = repository;
            this.ref = ref;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

