/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.scripting;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.descriptors.InlineMethodDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.scripting.JavaUIRefactoringContribution;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class InlineMethodRefactoringContribution
extends JavaUIRefactoringContribution {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Refactoring createRefactoring(JavaRefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        String handle;
        int selectionStart = -1;
        int selectionLength = -1;
        ICompilationUnit unit = null;
        CompilationUnit node = null;
        if (!(descriptor instanceof InlineMethodDescriptor)) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments, null));
        InlineMethodDescriptor extended = (InlineMethodDescriptor)descriptor;
        Map arguments = this.retrieveArgumentMap((RefactoringDescriptor)extended);
        String selection = (String)arguments.get("selection");
        if (selection != null) {
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}), null));
            selectionStart = offset;
            selectionLength = length;
        }
        if ((handle = (String)arguments.get("input")) == null) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"), null));
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(descriptor.getProject(), handle, false);
        if (element == null || !element.exists()) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{RefactoringCoreMessages.InlineMethodRefactoring_name, "org.eclipse.jdt.ui.inline.method"}), null));
        }
        if (element instanceof ICompilationUnit) {
            unit = (ICompilationUnit)element;
            if (selection == null) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"), null));
            }
        } else {
            if (!(element instanceof IMethod)) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}), null));
            IMethod method = (IMethod)element;
            try {
                ISourceRange range = method.getNameRange();
                if (range == null) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}), null));
                }
                selectionStart = range.getOffset();
                selectionLength = range.getLength();
            }
            catch (JavaModelException exception) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{RefactoringCoreMessages.InlineMethodRefactoring_name, "org.eclipse.jdt.ui.inline.method"}), (Throwable)exception));
            }
            unit = method.getCompilationUnit();
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setSource(unit);
        node = (CompilationUnit)parser.createAST(null);
        return InlineMethodRefactoring.create((ITypeRoot)unit, node, selectionStart, selectionLength);
    }

    public RefactoringDescriptor createDescriptor() {
        return RefactoringSignatureDescriptorFactory.createInlineMethodDescriptor();
    }

    public final RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        return RefactoringSignatureDescriptorFactory.createInlineMethodDescriptor((String)project, (String)description, (String)comment, arguments, (int)flags);
    }
}

