/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.theme;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.fx.ui.services.theme.Stylesheet;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.jdt.annotation.NonNull;

public class AbstractTheme
implements Theme {
    private final @NonNull String id;
    private final @NonNull String name;
    private final @NonNull List<@NonNull URL> stylesheetUrlList = new ArrayList<URL>();

    public AbstractTheme(@NonNull String id, @NonNull String name, @NonNull URL baseStylesheetUrl) {
        this.id = id;
        this.name = name;
        this.stylesheetUrlList.add(baseStylesheetUrl);
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull List<@NonNull URL> getStylesheetURL() {
        return Collections.unmodifiableList(this.stylesheetUrlList);
    }

    public void registerStylesheet(Stylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this)) {
            this.stylesheetUrlList.add(stylesheet.getURL((Theme)this));
        }
    }

    public void unregisterStylesheet(Stylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this)) {
            this.stylesheetUrlList.remove(stylesheet.getURL((Theme)this));
        }
    }
}

