/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.perspective;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerspectiveListView {
    private final MWindow window;
    private final EModelService modelService;
    final GraphicsLoader graphicsLoader;
    private Consumer<MPerspective> openConsumer;
    private Consumer<MPerspective> selectionConsumer;
    private final MPerspective currentPerspective;
    private ListView<MPerspective> listView;

    @Inject
    public PerspectiveListView(MWindow window, EModelService modelService, GraphicsLoader graphicsLoader) {
        this.window = window;
        this.modelService = modelService;
        this.graphicsLoader = graphicsLoader;
        List list = modelService.findElements((MUIElement)window, null, MPerspectiveStack.class, null);
        this.currentPerspective = !list.isEmpty() ? (((MPerspectiveStack)list.get(0)).getSelectedElement() != null ? (MPerspective)((MPerspectiveStack)list.get(0)).getSelectedElement() : (!((MPerspectiveStack)list.get(0)).getChildren().isEmpty() ? (MPerspective)((MPerspectiveStack)list.get(0)).getChildren().get(0) : null)) : null;
    }

    @PostConstruct
    public void init(BorderPane parent) {
        this.listView = new ListView();
        this.listView.getStyleClass().add((Object)"efx-perspective-list");
        this.listView.setCellFactory(listView -> new PerspectiveCell((ListView<MPerspective>)listView));
        List list = this.modelService.findElements((MUIElement)this.window, null, MPerspective.class, null);
        this.listView.setItems(FXCollections.observableArrayList((Collection)list.stream().filter(e -> e.isToBeRendered()).collect(Collectors.toList())));
        this.listView.getSelectionModel().selectedItemProperty().addListener((o, ol, ne) -> {
            if (this.selectionConsumer != null) {
                this.selectionConsumer.accept((MPerspective)ne);
            }
        });
        this.listView.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getClickCount() > 1) {
                this.handleOpenRequest();
            }
        });
        this.listView.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.handleOpenRequest();
            }
        });
        parent.setCenter(this.listView);
        this.listView.getSelectionModel().select((Object)this.currentPerspective);
    }

    private void handleOpenRequest() {
        MPerspective selectedItem = (MPerspective)this.listView.getSelectionModel().getSelectedItem();
        if (this.openConsumer != null && selectedItem != null) {
            this.openConsumer.accept(selectedItem);
        }
    }

    public void setOpenConsumer(@Nullable Consumer<@NonNull MPerspective> openConsumer) {
        this.openConsumer = openConsumer;
    }

    public void setSelectionConsumer(@Nullable Consumer<@NonNull MPerspective> selectionConsumer) {
        this.selectionConsumer = selectionConsumer;
    }

    class PerspectiveCell
    extends ListCell<MPerspective> {
        public PerspectiveCell(ListView<MPerspective> list) {
        }

        protected void updateItem(MPerspective item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null && !empty) {
                this.setText(item.getLocalizedLabel());
                String iconURI = item.getIconURI();
                if (iconURI != null) {
                    EMFUri uri = new EMFUri(URI.createURI((String)iconURI));
                    this.setGraphic(PerspectiveListView.this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)uri));
                } else {
                    this.setGraphic(null);
                }
            } else {
                this.setText("");
                this.setGraphic(null);
            }
        }
    }
}

