/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

class ConfigApplier {
    private static final String LAST_BUNDLES_INFO = "last.bundles.info";
    private static final String PROP_DEVMODE = "osgi.dev";
    private final BundleContext manipulatingContext;
    private final PackageAdmin packageAdminService;
    private final StartLevel startLevelService;
    private final FrameworkWiring frameworkWiring;
    private final boolean runningOnEquinox;
    private final boolean inDevMode;
    private final Bundle callingBundle;
    private final URI baseLocation;

    ConfigApplier(BundleContext context, Bundle callingBundle) {
        this.manipulatingContext = context;
        this.callingBundle = callingBundle;
        this.runningOnEquinox = "Eclipse".equals(context.getProperty("org.osgi.framework.vendor"));
        this.inDevMode = this.manipulatingContext.getProperty(PROP_DEVMODE) != null;
        this.baseLocation = this.runningOnEquinox ? EquinoxUtils.getInstallLocationURI(context) : null;
        ServiceReference packageAdminRef = this.manipulatingContext.getServiceReference(PackageAdmin.class);
        if (packageAdminRef == null) {
            throw new IllegalStateException("No PackageAdmin service is available.");
        }
        this.packageAdminService = (PackageAdmin)this.manipulatingContext.getService(packageAdminRef);
        ServiceReference startLevelRef = this.manipulatingContext.getServiceReference(StartLevel.class);
        if (startLevelRef == null) {
            throw new IllegalStateException("No StartLevelService service is available.");
        }
        this.startLevelService = (StartLevel)this.manipulatingContext.getService(startLevelRef);
        this.frameworkWiring = (FrameworkWiring)this.manipulatingContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
    }

    void install(URL url, boolean exclusiveMode) throws IOException {
        Bundle[] additionalRefresh;
        List<BundleInfo> bundleInfoList = SimpleConfiguratorUtils.readConfiguration(url, this.baseLocation);
        if (bundleInfoList.size() == 0) {
            return;
        }
        BundleInfo[] expectedState = Utils.getBundleInfosFromList(bundleInfoList);
        String systemBundleSymbolicName = this.manipulatingContext.getBundle(0L).getSymbolicName();
        Version systemBundleVersion = this.manipulatingContext.getBundle(0L).getVersion();
        if (systemBundleSymbolicName != null) {
            int i = 0;
            while (i < expectedState.length) {
                Version version;
                String symbolicName = expectedState[i].getSymbolicName();
                if (systemBundleSymbolicName.equals(symbolicName) && !systemBundleVersion.equals((Object)(version = Version.parseVersion((String)expectedState[i].getVersion())))) {
                    throw new IllegalStateException("The System Bundle was updated. The framework must be restarted to finalize the configuration change");
                }
                ++i;
            }
        }
        HashSet<BundleInfo> toUninstall = null;
        if (!exclusiveMode) {
            BundleInfo[] lastInstalledBundles = this.getLastState();
            if (lastInstalledBundles != null) {
                toUninstall = new HashSet<BundleInfo>(Arrays.asList(lastInstalledBundles));
                toUninstall.removeAll(Arrays.asList(expectedState));
            }
            this.saveStateAsLast(url);
        }
        Set<Bundle> prevouslyResolved = this.getResolvedBundles();
        ArrayList<Bundle> toRefresh = new ArrayList<Bundle>();
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        if (exclusiveMode) {
            toRefresh.addAll(this.installBundles(expectedState, toStart));
            toRefresh.addAll(this.uninstallBundles(expectedState, this.packageAdminService));
        } else {
            toRefresh.addAll(this.installBundles(expectedState, toStart));
            if (toUninstall != null) {
                toRefresh.addAll(this.uninstallBundles(toUninstall));
            }
        }
        this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]), this.manipulatingContext);
        if (toRefresh.size() > 0 && (additionalRefresh = this.getAdditionalRefresh(prevouslyResolved, toRefresh)).length > 0) {
            this.refreshPackages(additionalRefresh, this.manipulatingContext);
        }
        this.startBundles(toStart.toArray(new Bundle[toStart.size()]));
    }

    private Bundle[] getAdditionalRefresh(Set<Bundle> previouslyResolved, Collection<Bundle> toRefresh) {
        BundleRevision revision;
        HashSet<Bundle> additionalRefresh = new HashSet<Bundle>();
        HashSet<Bundle> originalRefresh = new HashSet<Bundle>(toRefresh);
        for (Bundle bundle : toRefresh) {
            revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (bundle.getState() != 2 || revision == null || (revision.getTypes() & 1) == 0) continue;
            boolean foundPayLoadReq = false;
            BundleRequirement hostReq = null;
            List requirements = revision.getRequirements(null);
            for (BundleRequirement req : requirements) {
                if ("osgi.wiring.host".equals(req.getNamespace())) {
                    hostReq = req;
                }
                if ("osgi.wiring.host".equals(req.getNamespace()) || "osgi.ee".equals(req.getNamespace())) continue;
                foundPayLoadReq = true;
            }
            if (!foundPayLoadReq) continue;
            Collection candidates = this.frameworkWiring.findProviders(hostReq);
            for (BundleCapability candidate : candidates) {
                if (originalRefresh.contains(candidate.getRevision().getBundle())) continue;
                additionalRefresh.add(candidate.getRevision().getBundle());
            }
        }
        block3: for (Bundle bundle : previouslyResolved) {
            BundleWiring wiring;
            revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            BundleWiring bundleWiring = wiring = revision == null ? null : revision.getWiring();
            if (wiring == null) continue;
            List reqs = revision.getDeclaredRequirements(null);
            HashSet<BundleRequirement> optionalReqs = new HashSet<BundleRequirement>();
            for (BundleRequirement req : reqs) {
                String namespace = req.getNamespace();
                if (!"osgi.wiring.package".equals(namespace) && !"osgi.wiring.bundle".equals(namespace) || !"optional".equals(req.getDirectives().get("resolution"))) continue;
                optionalReqs.add(req);
            }
            if (optionalReqs.isEmpty()) continue;
            wiring = this.getHostWiring(wiring);
            List requiredWires = wiring.getRequiredWires(null);
            for (BundleWire requiredWire : requiredWires) {
                optionalReqs.remove(requiredWire.getRequirement());
            }
            if (optionalReqs.isEmpty()) continue;
            Iterator iOptionalReqs = optionalReqs.iterator();
            while (iOptionalReqs.hasNext()) {
                Collection candidates = this.frameworkWiring.findProviders((Requirement)iOptionalReqs.next());
                Iterator iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    BundleCapability candidate = (BundleCapability)iCandidates.next();
                    Bundle candidateBundle = candidate.getRevision().getBundle();
                    if (!previouslyResolved.contains(candidateBundle) && candidateBundle.getState() != 2) continue;
                    iCandidates.remove();
                }
                if (candidates.isEmpty()) continue;
                additionalRefresh.add(wiring.getBundle());
                continue block3;
            }
        }
        return additionalRefresh.toArray(new Bundle[additionalRefresh.size()]);
    }

    private BundleWiring getHostWiring(BundleWiring wiring) {
        if ((wiring.getRevision().getTypes() & 1) == 0) {
            return wiring;
        }
        List hostWires = wiring.getRequiredWires("osgi.wiring.host");
        if (hostWires.isEmpty()) {
            return wiring;
        }
        BundleWire hostWire = (BundleWire)hostWires.iterator().next();
        return hostWire.getProviderWiring();
    }

    private Set<Bundle> getResolvedBundles() {
        HashSet<Bundle> resolved = new HashSet<Bundle>();
        Bundle[] allBundles = this.manipulatingContext.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            if ((allBundles[i].getState() & 3) == 0) {
                resolved.add(allBundles[i]);
            }
            ++i;
        }
        return resolved;
    }

    private Collection<Bundle> uninstallBundles(HashSet<BundleInfo> toUninstall) {
        ArrayList<Bundle> removedBundles = new ArrayList<Bundle>(toUninstall.size());
        for (BundleInfo current : toUninstall) {
            Bundle[] matchingBundles = this.packageAdminService.getBundles(current.getSymbolicName(), this.getVersionRange(current.getVersion()));
            int j = 0;
            while (matchingBundles != null && j < matchingBundles.length) {
                try {
                    removedBundles.add(matchingBundles[j]);
                    matchingBundles[j].uninstall();
                }
                catch (BundleException bundleException) {}
                ++j;
            }
        }
        return removedBundles;
    }

    private void saveStateAsLast(URL url) {
        InputStream sourceStream = null;
        FileOutputStream destinationStream = null;
        File lastBundlesTxt = this.getLastBundleInfo();
        try {
            try {
                try {
                    destinationStream = new FileOutputStream(lastBundlesTxt);
                    ArrayList<File> sourcesLocation = SimpleConfiguratorUtils.getInfoFiles();
                    ArrayList<InputStream> sourceStreams = new ArrayList<InputStream>(sourcesLocation.size() + 1);
                    sourceStreams.add(url.openStream());
                    if (Activator.EXTENDED) {
                        int i = 0;
                        while (i < sourcesLocation.size()) {
                            sourceStreams.add(new FileInputStream(sourcesLocation.get(i)));
                            ++i;
                        }
                    }
                    SimpleConfiguratorUtils.transferStreams(sourceStreams, destinationStream);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (destinationStream != null) {
                        ((OutputStream)destinationStream).close();
                    }
                    if (sourceStream != null) {
                        sourceStream.close();
                    }
                }
            }
            finally {
                if (destinationStream != null) {
                    ((OutputStream)destinationStream).close();
                }
                if (sourceStream != null) {
                    sourceStream.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    private File getLastBundleInfo() {
        return this.manipulatingContext.getDataFile(LAST_BUNDLES_INFO);
    }

    private BundleInfo[] getLastState() {
        File lastBundlesInfo = this.getLastBundleInfo();
        if (!lastBundlesInfo.isFile()) {
            return null;
        }
        try {
            return SimpleConfiguratorUtils.readConfiguration(lastBundlesInfo.toURL(), this.baseLocation).toArray(new BundleInfo[1]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ArrayList<Bundle> installBundles(BundleInfo[] finalList, Collection<Bundle> toStart) {
        ArrayList<Bundle> toRefresh = new ArrayList<Bundle>();
        String useReferenceProperty = this.manipulatingContext.getProperty("org.eclipse.equinox.simpleconfigurator.useReference");
        boolean useReference = useReferenceProperty == null ? this.runningOnEquinox : Boolean.parseBoolean(useReferenceProperty);
        int i = 0;
        while (i < finalList.length) {
            block19: {
                if (finalList[i] != null) {
                    int startLevel;
                    Bundle current;
                    String symbolicName = finalList[i].getSymbolicName();
                    String version = finalList[i].getVersion();
                    Bundle[] matches = null;
                    if (symbolicName != null && version != null) {
                        matches = this.packageAdminService.getBundles(symbolicName, this.getVersionRange(version));
                    }
                    String bundleLocation = SimpleConfiguratorUtils.getBundleLocation(finalList[i], useReference);
                    Bundle bundle = matches == null ? null : (current = matches.length == 0 ? null : matches[0]);
                    if (current == null) {
                        try {
                            current = this.manipulatingContext.installBundle(bundleLocation);
                            if (symbolicName != null && version != null) {
                                try {
                                    Version v = new Version(version);
                                    if (!symbolicName.equals(current.getSymbolicName()) || !v.equals((Object)current.getVersion())) {
                                        current.update();
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            toRefresh.add(current);
                        }
                        catch (BundleException e) {
                            break block19;
                        }
                    }
                    if (this.inDevMode && current.getBundleId() != 0L && current != this.manipulatingContext.getBundle() && !bundleLocation.equals(current.getLocation()) && !current.getLocation().startsWith("initial@")) {
                        try {
                            current.uninstall();
                            toRefresh.add(current);
                        }
                        catch (BundleException e) {
                            break block19;
                        }
                        try {
                            current = this.manipulatingContext.installBundle(bundleLocation);
                            toRefresh.add(current);
                        }
                        catch (BundleException e) {
                            break block19;
                        }
                    }
                    if (finalList[i].isMarkedAsStarted()) {
                        toStart.add(current);
                    }
                    if ((startLevel = finalList[i].getStartLevel()) >= 1 && current.getBundleId() != 0L && this.packageAdminService.getBundleType(current) != 1 && !"org.eclipse.equinox.simpleconfigurator".equals(current.getSymbolicName())) {
                        try {
                            this.startLevelService.setBundleStartLevel(current, startLevel);
                        }
                        catch (IllegalArgumentException ex) {
                            Utils.log(4, null, null, "Failed to set start level of Bundle:" + finalList[i], ex);
                        }
                    }
                }
            }
            ++i;
        }
        return toRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshPackages(Bundle[] bundles, BundleContext context) {
        if (bundles.length == 0 || this.packageAdminService == null) {
            return;
        }
        LinkedHashSet<Bundle> allSameBSNs = new LinkedHashSet<Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle[] sameBSNs;
            Bundle bundle = bundleArray[n2];
            allSameBSNs.add(bundle);
            String bsn = bundle.getSymbolicName();
            if (bsn != null && (sameBSNs = this.packageAdminService.getBundles(bsn, null)) != null) {
                allSameBSNs.addAll(Arrays.asList(sameBSNs));
            }
            ++n2;
        }
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        context.addFrameworkListener(listener);
        this.packageAdminService.refreshPackages(allSameBSNs.toArray(new Bundle[0]));
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    break;
                }
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            context.removeFrameworkListener(listener);
            return;
        }
    }

    private void startBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if (bundle.getState() == 1) {
                System.err.println("Could not start: " + bundle.getSymbolicName() + '(' + bundle.getLocation() + ':' + bundle.getBundleId() + ')' + ". It's state is uninstalled.");
            } else if ((bundle.getState() != 8 || bundle != this.callingBundle && bundle != this.manipulatingContext.getBundle()) && this.packageAdminService.getBundleType(bundle) != 1 && bundle.getBundleId() != 0L) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private Collection<Bundle> uninstallBundles(BundleInfo[] finalList, PackageAdmin packageAdmin) {
        Bundle[] allBundles = this.manipulatingContext.getBundles();
        HashSet<Bundle> removedBundles = new HashSet<Bundle>(allBundles.length);
        int i = 0;
        while (i < allBundles.length) {
            if (allBundles[i].getBundleId() != 0L) {
                removedBundles.add(allBundles[i]);
            }
            ++i;
        }
        i = 0;
        while (i < finalList.length) {
            if (finalList[i] != null) {
                Bundle[] toAdd = packageAdmin.getBundles(finalList[i].getSymbolicName(), this.getVersionRange(finalList[i].getVersion()));
                int j = 0;
                while (toAdd != null && j < toAdd.length) {
                    removedBundles.remove(toAdd[j]);
                    ++j;
                }
            }
            ++i;
        }
        Iterator iter = removedBundles.iterator();
        while (iter.hasNext()) {
            try {
                Bundle bundle = (Bundle)iter.next();
                if (bundle.getLocation().startsWith("initial@")) {
                    iter.remove();
                    continue;
                }
                bundle.uninstall();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        return removedBundles;
    }

    private String getVersionRange(String version) {
        return version == null ? null : new StringBuffer().append('[').append(version).append(',').append(version).append(']').toString();
    }
}

