/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.LineSeparatorHarmonizer;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.xtext.generator.parser.antlr.KeywordHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.MutableTokenDefProvider;
import org.eclipse.xtext.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrCodeQualityHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.PartialClassExtractor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.SyntacticPredicateFixup;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;

public abstract class AbstractAntlrGeneratorFragment2
extends AbstractXtextGeneratorFragment {
    private AntlrToolFacade antlrTool;
    @Inject
    private AntlrCodeQualityHelper codeQualityHelper;
    @Inject
    private LineSeparatorHarmonizer newLineNormalizer;
    @Inject
    private CodeConfig codeConfig;
    private AntlrOptions options = new AntlrOptions();
    private ArrayList<String> antlrParams = new ArrayList();
    private String dowloadUrl;

    @Inject
    private void setAntlrToolFacade(AntlrToolFacade antlrTool) {
        if (this.dowloadUrl != null) {
            antlrTool.setSecureDownloadFrom(this.dowloadUrl);
        }
        this.antlrTool = antlrTool;
    }

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        ArrayList params = Lists.newArrayList(this.antlrParams);
        if (!params.contains("-Xconversiontimeout")) {
            params.add(0, "-Xconversiontimeout");
            params.add(1, "100000");
        }
        return params.toArray(new String[0]);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (!this.antlrTool.isWorkable()) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment 'org.eclipse.xtext.generator.parser.packrat.PackratParserFragment' in your mwe2 file instead.");
        }
    }

    @Override
    public void generate() {
        this.checkGrammar();
        this.doGenerate();
    }

    protected abstract void doGenerate();

    protected void checkGrammar() {
        if (!this.hasProductionRules(this.getGrammar())) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
    }

    protected boolean hasProductionRules(Grammar grammar) {
        AbstractRule firstRule = (AbstractRule)grammar.getRules().get(0);
        return firstRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)firstRule));
    }

    protected void splitLexerClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer) {
        String content = fsa.readTextFile(lexer.getJavaPath()).toString();
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        splitter.setCasesPerSpecialStateSwitch(this.options.getCasesPerSpecialStateSwitch());
        fsa.generateFile(lexer.getJavaPath(), splitter.transform());
    }

    protected void splitParserClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, this.getOptions().getFieldsPerClass());
        PartialClassExtractor extractor = new PartialClassExtractor(splitter.transform(), this.getOptions().getMethodsPerClass());
        fsa.generateFile(parser.getJavaPath(), extractor.transform());
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        if (this.containsUnorderedGroup(grammar) || this.hasParameterizedRules(grammar)) {
            this.simplifyUnorderedGroupPredicates(fsa, parser);
        }
    }

    protected boolean hasParameterizedRules(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            if (rule.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void simplifyUnorderedGroupPredicates(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        SyntacticPredicateFixup fixup = new SyntacticPredicateFixup(transformed);
        transformed = fixup.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        fsa.generateFile(parser.getJavaPath(), newContent);
    }

    protected void suppressWarnings(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String content = fsa.readTextFile(type.getJavaPath()).toString();
        String newContent = new SuppressWarningsProcessor().process(content);
        fsa.generateFile(type.getJavaPath(), newContent);
    }

    protected void suppressWarnings(IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        if (types != null) {
            for (TypeReference it : types) {
                this.suppressWarnings(fsa, it);
            }
        }
    }

    protected void normalizeLineDelimiters(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String content = fsa.readTextFile(type.getJavaPath()).toString();
        content = this.newLineNormalizer.postProcess(fsa.getURI(type.getJavaPath()), (CharSequence)content).toString();
        content = content.replaceAll("\"\\+(\\r)?\\n\\s+\"", "");
        fsa.generateFile(type.getJavaPath(), content);
    }

    protected void normalizeLineDelimiters(IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        if (types != null) {
            for (TypeReference it : types) {
                this.normalizeLineDelimiters(fsa, it);
            }
        }
    }

    protected void normalizeTokens(IXtextGeneratorFileSystemAccess fsa, String tokenFile) {
        String content = fsa.readTextFile(tokenFile).toString();
        content = this.newLineNormalizer.postProcess(fsa.getURI(tokenFile), (CharSequence)content).toString();
        List splitted = Strings.split((String)content, (String)this.codeConfig.getLineDelimiter());
        Collections.sort(splitted);
        content = Strings.concat((String)this.codeConfig.getLineDelimiter(), (List)splitted) + this.codeConfig.getLineDelimiter();
        fsa.generateFile(tokenFile, content);
    }

    protected void splitParserAndLexerIfEnabled(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, TypeReference lexer) {
        this.improveCodeQuality(fsa, lexer, parser);
        if (this.getOptions().isClassSplitting()) {
            this.splitLexerClassFile(fsa, lexer);
            this.splitParserClassFile(fsa, parser);
        }
    }

    protected void improveCodeQuality(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer, TypeReference parser) {
        this.improveLexerCodeQuality(fsa, lexer);
        this.improveParserCodeQuality(fsa, parser);
    }

    protected void improveParserCodeQuality(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String parserContent = fsa.readTextFile(parser.getJavaPath()).toString();
        parserContent = this.codeQualityHelper.stripUnnecessaryComments(parserContent, this.options);
        parserContent = this.codeQualityHelper.removeDuplicateBitsets(parserContent, this.options);
        parserContent = this.codeQualityHelper.removeDuplicateDFAs(parserContent, this.options);
        fsa.generateFile(parser.getJavaPath(), parserContent);
    }

    protected void improveLexerCodeQuality(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer) {
        String lexerContent = fsa.readTextFile(lexer.getJavaPath()).toString();
        lexerContent = this.codeQualityHelper.stripUnnecessaryComments(lexerContent, this.options);
        fsa.generateFile(lexer.getJavaPath(), lexerContent);
    }

    protected void cleanupLexerTokensFile(AntlrGrammar lexerGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            if (this.options.isBacktrackLexer()) {
                MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
                Iterator entries = provider.getTokenDefMap().entrySet().iterator();
                while (entries.hasNext()) {
                    String value = (String)entries.next().getValue();
                    if (helper.isKeywordRule(value) || value.startsWith("RULE_") || value.startsWith("SUPER_")) continue;
                    entries.remove();
                }
                CharArrayWriter writer = new CharArrayWriter();
                provider.writeTokenFile(new PrintWriter(writer));
                fsa.generateFile(lexerGrammar.getTokensFileName(), new String(writer.toCharArray()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected MutableTokenDefProvider createLexerTokensProvider(AntlrGrammar lexerGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        MutableTokenDefProvider provider = new MutableTokenDefProvider(helper, Charset.forName(this.codeConfig.getEncoding()));
        provider.setAntlrTokenFileProvider(() -> fsa.readBinaryFile(lexerGrammar.getTokensFileName()));
        return provider;
    }

    protected void cleanupParserTokensFile(AntlrGrammar lexerGrammar, AntlrGrammar parserGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
            for (Map.Entry entry : provider.getTokenDefMap().entrySet()) {
                String value = (String)entry.getValue();
                if (helper.isKeywordRule(value)) {
                    String keywordAsAntlrString = AntlrGrammarGenUtil.toAntlrString(helper.getKeywordValue(value));
                    entry.setValue("'" + keywordAsAntlrString + "'");
                    continue;
                }
                if (!value.startsWith("'")) continue;
                entry.setValue("'" + AntlrGrammarGenUtil.toAntlrString(value) + "'");
            }
            CharArrayWriter writer = new CharArrayWriter();
            provider.writeTokenFile(new PrintWriter(writer));
            fsa.generateFile(parserGrammar.getTokensFileName(), new String(writer.toCharArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void removeBackTrackingGuards(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, int lookaheadThreshold) {
        String content = fsa.readTextFile(parser.getJavaPath()).toString();
        BacktrackingGuardRemover remover = new BacktrackingGuardRemover(content, lookaheadThreshold);
        String newContent = remover.transform();
        fsa.generateFile(parser.getJavaPath(), newContent);
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            if (!Iterators.filter((Iterator)rule.eAllContents(), UnorderedGroup.class).hasNext()) continue;
            return true;
        }
        return false;
    }

    protected AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    protected AntlrCodeQualityHelper getCodeQualityHelper() {
        return this.codeQualityHelper;
    }

    protected LineSeparatorHarmonizer getNewLineNormalizer() {
        return this.newLineNormalizer;
    }

    protected CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    public AntlrOptions getOptions() {
        return this.options;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }

    public void setDownloadUrl(String url) {
        this.dowloadUrl = url;
    }
}

