/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.converter.FXMLConverter;
import org.eclipse.fx.formats.svg.svg.ContentElement;
import org.eclipse.fx.formats.svg.svg.CoreAttributes;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgPackage;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoader {
    private static final Map<String, String> SUFFIXMAP = new HashMap<String, String>();

    public XMLLoader() {
        SUFFIXMAP.put("image/png", "png");
        SUFFIXMAP.put("image/jpeg", "jpg");
        SUFFIXMAP.put("image/jpg", "jpg");
        SUFFIXMAP.put("image/gif", "gif");
    }

    public static void main(String[] args) {
        XMLLoader l = new XMLLoader();
        try {
            File f = new File("/Users/tomschindl/git/e-fx-clipse/org.eclipse.fx.formats.svg/samples/lr.svg");
            InputStream in = f.getName().endsWith("svgz") ? new GZIPInputStream(f.toURI().toURL().openStream()) : f.toURI().toURL().openStream();
            SvgSvgElement g = l.loadDocument("/Users/tomschindl/git/e-fx-clipse/org.eclipse.fx.formats.svg/samples/test.fxml", in);
            FXMLConverter c = new FXMLConverter(g);
            String fxmlData = c.generate().toString();
            File outFile = new File("/Users/tomschindl/git/e-fx-clipse/org.eclipse.fx.formats.svg/samples/test.fxml");
            FileOutputStream out = new FileOutputStream(outFile);
            out.write(fxmlData.getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SvgSvgElement loadDocument(String outFile, InputStream in) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            parser.parse(in, (DefaultHandler)handler);
            this.postProcess(outFile, handler.cssString, handler.root);
            return handler.root;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void postProcess(String outFile, StringBuilder cssString, SvgSvgElement root) throws IOException {
        int imageCount = 0;
        TreeIterator it = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        if (cssString != null) {
            File outCssFile;
            if (outFile == null) {
                outCssFile = File.createTempFile("conversion", ".css");
                outCssFile.deleteOnExit();
            } else {
                outCssFile = new File(String.valueOf(outFile) + ".css");
            }
            try {
                FileOutputStream out = new FileOutputStream(outCssFile);
                out.write(cssString.toString().getBytes());
                out.close();
                root.setStyleSheet("@" + outCssFile.getName());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        block6: while (it.hasNext()) {
            String s;
            EObject o = (EObject)it.next();
            EStructuralFeature f = o.eClass().getEStructuralFeature("style");
            if (f != null && (s = (String)o.eGet(f)) != null && s.trim().length() > 0) {
                for (Map.Entry<String, String> e : this.valueMap(s).entrySet()) {
                    String name = e.getKey().replaceAll("-", "_");
                    EStructuralFeature styleFeature = o.eClass().getEStructuralFeature(name.trim());
                    if (styleFeature != null) {
                        Object value = EcoreUtil.createFromString((EDataType)((EDataType)styleFeature.getEType()), (String)e.getValue());
                        o.eSet(styleFeature, value);
                        continue;
                    }
                    System.err.println("Could not find style attribute: " + name + " on " + o.eClass());
                }
            }
            if ((f = o.eClass().getEStructuralFeature("xlink__href")) == null) continue;
            EStructuralFeature instanceFeature = o.eClass().getEStructuralFeature("resolvedInstance");
            String link = (String)o.eGet(f);
            if (link != null && link.startsWith("data:")) {
                String type = link.substring(0, link.indexOf(59));
                String data = link.substring(link.indexOf(44) + 1);
                byte[] b = DatatypeConverter.parseBase64Binary((String)data);
                try {
                    File outDir;
                    String suffix = SUFFIXMAP.get(type.toLowerCase());
                    if (suffix == null) {
                        suffix = type.substring(type.indexOf(47) + 1);
                    }
                    if (outFile == null) {
                        outDir = File.createTempFile("conversion", "_img");
                        outDir.delete();
                    } else {
                        outDir = new File(String.valueOf(outFile) + "img");
                    }
                    File outF = new File(outDir, "img_" + imageCount++ + "." + suffix);
                    outDir.mkdirs();
                    FileOutputStream out = new FileOutputStream(outF);
                    out.write(b);
                    out.close();
                    o.eSet(f, (Object)("@" + outDir.getName() + "/" + outF.getName()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (link == null || link.trim().length() <= 0) continue;
            link = link.substring(1);
            TreeIterator internalIt = EcoreUtil.getAllContents((EObject)root, (boolean)true);
            while (internalIt.hasNext()) {
                EObject internalO = (EObject)internalIt.next();
                if (!(internalO instanceof CoreAttributes) || !link.equals(internalO.eGet((EStructuralFeature)SvgPackage.Literals.CORE_ATTRIBUTES__ID))) continue;
                o.eSet(instanceFeature, (Object)EcoreUtil.copy((EObject)internalO));
                continue block6;
            }
        }
    }

    private Map<String, String> valueMap(String styleString) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = styleString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            String k = o.substring(0, o.indexOf(":"));
            String v = o.substring(o.indexOf(":") + 1, o.length());
            map.put(k, v);
            ++n2;
        }
        return map;
    }

    static class Handler
    extends DefaultHandler {
        private SvgSvgElement root;
        private Stack<SvgElement> elementStack = new Stack();
        private boolean inCSS;
        private StringBuilder cssString;
        private static final String SVG_NS = "http://www.w3.org/2000/svg";
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";

        Handler() {
        }

        @Override
        public InputSource resolveEntity(String arg0, String arg1) throws IOException, SAXException {
            return new InputSource(new StringReader(""));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (SVG_NS.equals(uri)) {
                if (localName.equals("style")) {
                    this.inCSS = true;
                    this.cssString = new StringBuilder();
                    return;
                }
                EClass ec = (EClass)SvgPackage.eINSTANCE.getEClassifier("Svg" + Character.toUpperCase(localName.charAt(0)) + localName.substring(1) + "Element");
                if (ec != null) {
                    SvgElement e = (SvgElement)EcoreUtil.create((EClass)ec);
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Object o;
                        EStructuralFeature f;
                        String name;
                        if (SVG_NS.equals(attributes.getURI(i)) || "".equals(attributes.getURI(i))) {
                            name = attributes.getLocalName(i).replaceAll("-", "_");
                            f = e.eClass().getEStructuralFeature(name);
                            if (f != null) {
                                o = EcoreUtil.createFromString((EDataType)((EDataType)f.getEType()), (String)attributes.getValue(i));
                                e.eSet(f, o);
                            } else {
                                System.err.println("Could not find feature '" + name + "' in " + e.eClass().getName());
                            }
                        } else if (XLINK_NS.equals(attributes.getURI(i))) {
                            name = "xlink__" + attributes.getLocalName(i).replaceAll("-", "_");
                            f = e.eClass().getEStructuralFeature(name);
                            if (f != null) {
                                o = EcoreUtil.createFromString((EDataType)((EDataType)f.getEType()), (String)attributes.getValue(i));
                                e.eSet(f, o);
                            } else {
                                System.err.println("Could not find feature '" + name + "' in " + e.eClass().getName());
                            }
                        }
                        ++i;
                    }
                    if (this.elementStack.isEmpty()) {
                        this.root = (SvgSvgElement)e;
                    } else {
                        ((ContentElement)((Object)this.elementStack.peek())).getChildren().add((Object)e);
                    }
                    this.elementStack.push(e);
                } else {
                    throw new IllegalStateException("Unable to find element '" + localName + "'");
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCSS) {
                this.cssString.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("style")) {
                this.inCSS = false;
            } else if (SVG_NS.equals(uri) && !localName.equals("svg")) {
                this.elementStack.pop();
            }
        }
    }
}

