/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.util;

import org.eclipse.emf.ecp.common.util.Activator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class DialogHandler {
    private DialogHandler() {
    }

    public static void showExceptionDialog(Exception e) {
        DialogHandler.showExceptionDialog("Unexpected exception occured", e);
    }

    public static void showErrorDialog(String message) {
        DialogHandler.showExceptionDialog(message, null);
    }

    public static void showExceptionDialog(String message, Exception cause) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        String title = "Error";
        if (cause != null) {
            stringBuilder.append(": ");
            stringBuilder.append(cause.getMessage());
            title = cause.getClass().getName();
        }
        String string = stringBuilder.toString();
        MessageDialog.openError((Shell)shell, (String)title, (String)string);
        Activator.getDefault().logWarning("An unexpected error in a ECP plugin occured.", cause);
    }
}

