/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.util.UiUtil;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AltKeyDoubleClickAction
extends Action
implements IDoubleClickListener,
Listener {
    private ColumnViewer viewer;
    private boolean isAltKeyPressed;
    private String classname;
    private static String meeditorid = "org.eclipse.emf.ecp.editor";

    public AltKeyDoubleClickAction() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().addFilter(1, (Listener)this);
    }

    public AltKeyDoubleClickAction(String sourceView) {
        this();
        this.classname = sourceView;
    }

    public AltKeyDoubleClickAction(ColumnViewer viewer, String sourceView) {
        this(sourceView);
        this.viewer = viewer;
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void run() {
        this.openSelectedModelelement();
    }

    private void openSelectedModelelement() {
        EObject me = UiUtil.getSelectedModelelement();
        if (me == null) {
            return;
        }
        if (this.classname == null || this.classname.equals("")) {
            return;
        }
        ActionHelper.openModelElement((EObject)me, (String)this.classname);
    }

    public void handleEvent(Event event) {
        if (event.keyCode == 65536) {
            this.isAltKeyPressed = true;
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.isAltKeyPressed) {
            this.closeActiveMEEditor();
        }
        this.isAltKeyPressed = false;
        this.run();
    }

    private void closeActiveMEEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow workbenchwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchwindow != null && (page = workbenchwindow.getActivePage()) != null && (editor = page.getActiveEditor()) != null && editor.getSite().getId().equals(meeditorid)) {
            page.closeEditor(editor, true);
        }
    }
}

