/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.AttributeConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.CompositeConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.DeletionConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.DiagramLayoutConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiAttributeConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiAttributeMoveConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiAttributeMoveSetConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiAttributeSetConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiAttributeSetSetConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceSetConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceSetSetConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceSetSingleConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceSingleConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.ReferenceConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionManager {
    private final Project project;
    private final ChangePackage myChangePackage;
    private final List<ChangePackage> theirChangePackages;
    private ConflictDetector conflictDetector;
    private ArrayList<Conflict> conflicts;
    private ArrayList<AbstractOperation> notInvolvedInConflict;
    private ArrayList<AbstractOperation> acceptedMine;
    private ArrayList<AbstractOperation> rejectedTheirs;
    private final PrimaryVersionSpec baseVersion;
    private final PrimaryVersionSpec targetVersion;
    private ChangePackageVisualizationHelper visualizationHelper;

    public DecisionManager(Project project, ChangePackage myChangePackage, List<ChangePackage> theirChangePackages, PrimaryVersionSpec baseVersion, PrimaryVersionSpec targetVersion) {
        this.project = project;
        this.myChangePackage = myChangePackage;
        this.theirChangePackages = theirChangePackages;
        this.baseVersion = baseVersion;
        this.targetVersion = targetVersion;
        this.conflictDetector = new ConflictDetector();
        this.init();
    }

    private void init() {
        EList myOperations = this.myChangePackage.getOperations();
        ArrayList theirOperations = new ArrayList();
        for (ChangePackage cp : this.theirChangePackages) {
            theirOperations.addAll(cp.getOperations());
        }
        this.acceptedMine = new ArrayList();
        this.rejectedTheirs = new ArrayList();
        this.notInvolvedInConflict = new ArrayList();
        this.conflicts = new ArrayList();
        ArrayList<Conflicting> conflicting = new ArrayList<Conflicting>();
        ListIterator myIterator = myOperations.listIterator(myOperations.size());
        while (myIterator.hasPrevious()) {
            AbstractOperation myOperation = (AbstractOperation)myIterator.previous();
            boolean involved = false;
            ListIterator theirIterator = theirOperations.listIterator(theirOperations.size());
            while (theirIterator.hasPrevious()) {
                AbstractOperation theirOperation = (AbstractOperation)theirIterator.previous();
                if (!this.conflictDetector.doConflict(myOperation, theirOperation)) continue;
                involved = true;
                boolean conflictingYet = false;
                ArrayList<Conflicting> tmpConf = new ArrayList<Conflicting>();
                for (Conflicting conf : conflicting) {
                    if (!conf.add(myOperation, theirOperation)) continue;
                    tmpConf.add(conf);
                    conflictingYet = true;
                }
                if (tmpConf.size() > 1) {
                    Conflicting main = (Conflicting)tmpConf.get(0);
                    int i = 1;
                    while (i < tmpConf.size()) {
                        Conflicting conf = (Conflicting)tmpConf.get(i);
                        main.addMyOps(conf.getMyOperations());
                        main.addTheirOps(conf.getTheirOperations());
                        conflicting.remove(conf);
                        ++i;
                    }
                }
                if (conflictingYet) continue;
                conflicting.add(new Conflicting(myOperation, theirOperation));
            }
            if (involved) continue;
            this.notInvolvedInConflict.add(myOperation);
        }
        this.createConflicts(conflicting);
    }

    private void createConflicts(ArrayList<Conflicting> conflicting) {
        for (Conflicting conf : conflicting) {
            AbstractOperation my = conf.getMyOperation();
            AbstractOperation their = conf.getTheirOperation();
            if (OperationUtil.isDiagramLayout((AbstractOperation)my) && OperationUtil.isDiagramLayout((AbstractOperation)their)) {
                this.addConflict(this.createDiagramLayoutDecision(conf));
                continue;
            }
            if (OperationUtil.isAttribute((AbstractOperation)my) && OperationUtil.isAttribute((AbstractOperation)their)) {
                this.addConflict(this.createAttributeAttributeDecision(conf));
                continue;
            }
            if (OperationUtil.isSingleRef((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their)) {
                this.addConflict(this.createSingleSingleConflict(conf));
                continue;
            }
            if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isMultiRef((AbstractOperation)their)) {
                this.addConflict(this.createMultiMultiConflict(conf));
                continue;
            }
            if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their) || OperationUtil.isMultiRef((AbstractOperation)their) && OperationUtil.isSingleRef((AbstractOperation)my)) {
                this.addConflict(this.createMultiSingle(conf));
                continue;
            }
            if (OperationUtil.isCompositeRef((AbstractOperation)my) && OperationUtil.isCompositeRef((AbstractOperation)their)) {
                this.addConflict(this.createReferenceConflict(conf));
                continue;
            }
            if (OperationUtil.isCompositeRef((AbstractOperation)my) && (OperationUtil.isMultiRef((AbstractOperation)their) || OperationUtil.isSingleRef((AbstractOperation)their)) || (OperationUtil.isMultiRef((AbstractOperation)my) || OperationUtil.isSingleRef((AbstractOperation)my)) && OperationUtil.isCompositeRef((AbstractOperation)their)) {
                this.addConflict(this.createReferenceCompVSSingleMulti(conf));
                continue;
            }
            if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isMultiRefSet((AbstractOperation)their) || OperationUtil.isMultiRef((AbstractOperation)their) && OperationUtil.isMultiRefSet((AbstractOperation)my)) {
                this.addConflict(this.createMultiRefMultiSet(conf));
                continue;
            }
            if (OperationUtil.isMultiRefSet((AbstractOperation)my) && OperationUtil.isMultiRefSet((AbstractOperation)their)) {
                this.addConflict(this.createMultiRefSetSet(conf));
                continue;
            }
            if (OperationUtil.isMultiRefSet((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their) || OperationUtil.isMultiRefSet((AbstractOperation)their) && OperationUtil.isSingleRef((AbstractOperation)my)) {
                this.addConflict(this.createMultiSetSingle(conf));
                continue;
            }
            if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAtt((AbstractOperation)their)) {
                this.addConflict(this.createMultiAtt(conf));
                continue;
            }
            if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAttSet((AbstractOperation)their) || OperationUtil.isMultiAtt((AbstractOperation)their) && OperationUtil.isMultiAttSet((AbstractOperation)my)) {
                this.addConflict(this.createMultiAttSet(conf));
                continue;
            }
            if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAttMove((AbstractOperation)their) || OperationUtil.isMultiAtt((AbstractOperation)their) && OperationUtil.isMultiAttMove((AbstractOperation)my)) {
                this.addConflict(this.createMultiAttMove(conf));
                continue;
            }
            if (OperationUtil.isMultiAttSet((AbstractOperation)my) && OperationUtil.isMultiAttMove((AbstractOperation)their) || OperationUtil.isMultiAttSet((AbstractOperation)their) && OperationUtil.isMultiAttMove((AbstractOperation)my)) {
                this.addConflict(this.createMultiAttMoveSet(conf));
                continue;
            }
            if (OperationUtil.isMultiAttSet((AbstractOperation)my) && OperationUtil.isMultiAttSet((AbstractOperation)their)) {
                this.addConflict(this.createMultiAttSetSet(conf));
                continue;
            }
            if (OperationUtil.isComposite((AbstractOperation)my) || OperationUtil.isComposite((AbstractOperation)their)) {
                this.addConflict(this.createCompositeConflict(conf));
                continue;
            }
            if (!OperationUtil.isDelete((AbstractOperation)my) && !OperationUtil.isDelete((AbstractOperation)their)) continue;
            this.addConflict(this.createDeleteOtherConflict(conf));
        }
    }

    private void addConflict(Conflict conflict) {
        if (conflict == null) {
            return;
        }
        this.conflicts.add(conflict);
    }

    private Conflict createMultiRefMultiSet(Conflicting conf) {
        if (OperationUtil.isMultiRef((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSetConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiReferenceSetConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiSetSingle(Conflicting conf) {
        if (OperationUtil.isMultiRefSet((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSetSingleConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiReferenceSetSingleConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiSingle(Conflicting conf) {
        if (OperationUtil.isMultiRef((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSingleConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiReferenceSingleConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiRefSetSet(Conflicting conf) {
        return new MultiReferenceSetSetConflict(conf.getMyOperations(), conf.getTheirOperations(), this);
    }

    private Conflict createMultiAttSetSet(Conflicting conf) {
        return new MultiAttributeSetSetConflict(conf.getMyOperations(), conf.getTheirOperations(), this);
    }

    private Conflict createMultiAtt(Conflicting conf) {
        if (((MultiAttributeOperation)conf.getMyOperation()).isAdd()) {
            return new MultiAttributeConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiAttributeConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiAttSet(Conflicting conf) {
        if (OperationUtil.isMultiAtt((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeSetConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiAttributeSetConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiAttMove(Conflicting conf) {
        if (OperationUtil.isMultiAtt((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeMoveConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiAttributeMoveConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createMultiAttMoveSet(Conflicting conf) {
        if (OperationUtil.isMultiAttSet((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeMoveSetConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiAttributeMoveSetConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    private Conflict createReferenceCompVSSingleMulti(Conflicting conf) {
        if (OperationUtil.isCompositeRef((AbstractOperation)conf.getMyOperation())) {
            return this.createRefFromSub(conf, (List<AbstractOperation>)((CompositeOperation)conf.getMyOperation()).getSubOperations(), Arrays.asList(conf.getTheirOperation()));
        }
        return this.createRefFromSub(conf, Arrays.asList(conf.getMyOperation()), (List<AbstractOperation>)((CompositeOperation)conf.getTheirOperation()).getSubOperations());
    }

    private Conflict createReferenceConflict(Conflicting conf) {
        EList myOperations = ((CompositeOperation)conf.getMyOperation()).getSubOperations();
        EList theirOperations = ((CompositeOperation)conf.getTheirOperation()).getSubOperations();
        return this.createRefFromSub(conf, (List<AbstractOperation>)myOperations, (List<AbstractOperation>)theirOperations);
    }

    private Conflict createRefFromSub(Conflicting conf, List<AbstractOperation> myOperations, List<AbstractOperation> theirOperations) {
        for (AbstractOperation myOp : myOperations) {
            for (AbstractOperation theirOp : theirOperations) {
                if (!this.conflictDetector.doConflict(myOp, theirOp)) continue;
                if (OperationUtil.isSingleRef((AbstractOperation)myOp)) {
                    return new ReferenceConflict(this.createSingleSingleConflict(myOp, theirOp), conf.getMyOperations(), conf.getTheirOperations());
                }
                if (OperationUtil.isMultiRef((AbstractOperation)myOp)) {
                    return new ReferenceConflict(this.createMultiMultiConflict(myOp, theirOp), conf.getMyOperations(), conf.getTheirOperations());
                }
                return null;
            }
        }
        return null;
    }

    private Conflict createAttributeAttributeDecision(Conflicting conflicting) {
        return new AttributeConflict(conflicting.getMyOperations(), conflicting.getTheirOperations(), this);
    }

    private Conflict createDiagramLayoutDecision(Conflicting conflicting) {
        return new DiagramLayoutConflict(conflicting.getMyOperations(), conflicting.getTheirOperations(), this);
    }

    private Conflict createSingleSingleConflict(Conflicting conflicting) {
        return new SingleReferenceConflict(conflicting.getMyOperations(), conflicting.getTheirOperations(), this);
    }

    private Conflict createSingleSingleConflict(AbstractOperation my, AbstractOperation their) {
        return new SingleReferenceConflict(Arrays.asList(my), Arrays.asList(their), this);
    }

    private Conflict createMultiMultiConflict(Conflicting conf) {
        if (((MultiReferenceOperation)conf.getMyOperation()).isAdd()) {
            return new MultiReferenceConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new MultiReferenceConflict(conf.getMyOperations(), conf.getTheirOperations(), this, false);
    }

    private Conflict createMultiMultiConflict(AbstractOperation my, AbstractOperation their) {
        if (((MultiReferenceOperation)my).isAdd()) {
            return new MultiReferenceConflict(Arrays.asList(my), Arrays.asList(their), this, true);
        }
        return new MultiReferenceConflict(Arrays.asList(their), Arrays.asList(my), this, false);
    }

    private Conflict createDeleteOtherConflict(Conflicting conf) {
        if (OperationUtil.isDelete((AbstractOperation)conf.getMyOperation())) {
            return new DeletionConflict(conf.getMyOperations(), conf.getTheirOperations(), true, this);
        }
        return new DeletionConflict(conf.getTheirOperations(), conf.getMyOperations(), false, this);
    }

    private Conflict createCompositeConflict(Conflicting conf) {
        if (OperationUtil.isComposite((AbstractOperation)conf.getMyOperation())) {
            return new CompositeConflict(conf.getMyOperations(), conf.getTheirOperations(), this, true);
        }
        return new CompositeConflict(conf.getTheirOperations(), conf.getMyOperations(), this, false);
    }

    public ArrayList<Conflict> getConflicts() {
        return this.conflicts;
    }

    public boolean isResolved() {
        boolean isResolved = true;
        for (Conflict conflict : this.conflicts) {
            boolean bl = isResolved = isResolved && conflict.isResolved();
        }
        return isResolved;
    }

    public List<AbstractOperation> getAcceptedMine() {
        return this.acceptedMine;
    }

    public List<AbstractOperation> getRejectedTheirs() {
        return this.rejectedTheirs;
    }

    public void calcResult() {
        if (!this.isResolved()) {
            return;
        }
        for (AbstractOperation myOp : this.myChangePackage.getOperations()) {
            if (this.notInvolvedInConflict.contains(myOp)) {
                this.acceptedMine.add(myOp);
                continue;
            }
            for (Conflict conflict : this.conflicts) {
                if (!conflict.getAcceptedMine().contains(myOp)) continue;
                this.acceptedMine.add(myOp);
            }
        }
        for (Conflict conflict : this.conflicts) {
            for (AbstractOperation ao : conflict.getAcceptedMine()) {
                if (this.acceptedMine.contains(ao)) continue;
                this.acceptedMine.add(ao);
            }
        }
        for (ChangePackage theirCP : this.theirChangePackages) {
            for (AbstractOperation theirOp : theirCP.getOperations()) {
                for (Conflict conflict : this.conflicts) {
                    if (!conflict.getRejectedTheirs().contains(theirOp)) continue;
                    this.rejectedTheirs.add(theirOp);
                }
            }
        }
    }

    public ConflictDetector getConflictDetector() {
        return this.conflictDetector;
    }

    public String getModelElementName(ModelElementId modelElementId) {
        return this.getModelElementName(this.getModelElement(modelElementId));
    }

    public String getModelElementName(EObject modelElement) {
        AdapterFactoryLabelProvider adapterFactory = DecisionUtil.getAdapterFactory();
        return adapterFactory.getText((Object)modelElement);
    }

    public EObject getModelElement(ModelElementId modelElementId) {
        EObject modelElement = this.project.getModelElement(modelElementId);
        if (modelElement == null && (modelElement = this.searchForCreatedME(modelElementId, (List<AbstractOperation>)this.myChangePackage.getOperations())) == null) {
            for (ChangePackage cp : this.theirChangePackages) {
                modelElement = this.searchForCreatedME(modelElementId, (List<AbstractOperation>)cp.getOperations());
                if (modelElement != null) break;
            }
        }
        return modelElement;
    }

    private EObject searchForCreatedME(ModelElementId modelElementId, List<AbstractOperation> operations) {
        for (AbstractOperation operation : operations) {
            EObject result = null;
            if (operation instanceof CreateDeleteOperation) {
                result = this.searchCreateAndDelete((CreateDeleteOperation)operation, modelElementId);
            } else {
                if (!(operation instanceof CompositeOperation)) continue;
                EList subOperations = ((CompositeOperation)operation).getSubOperations();
                result = this.searchForCreatedME(modelElementId, (List<AbstractOperation>)subOperations);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EObject searchCreateAndDelete(CreateDeleteOperation cdo, ModelElementId modelElementId) {
        EObject modelElement = cdo.getModelElement();
        if (modelElement == null) {
            return null;
        }
        Set containedModelElements = ModelUtil.getAllContainedModelElements((EObject)modelElement, (boolean)false);
        containedModelElements.add(modelElement);
        for (EObject child : containedModelElements) {
            ModelElementId childId = (ModelElementId)ModelUtil.clone((EObject)((ModelElementId)cdo.getEObjectToIdMap().get((Object)child)));
            if (childId == null || !childId.equals(modelElementId)) continue;
            return child;
        }
        return null;
    }

    public String getAuthorForOperation(AbstractOperation theirOperation) {
        for (ChangePackage cp : this.theirChangePackages) {
            for (AbstractOperation op : cp.getOperations()) {
                ArrayList<AbstractOperation> tmpList = new ArrayList<AbstractOperation>();
                if (op instanceof CompositeOperation) {
                    tmpList.add(op);
                    tmpList.addAll((Collection<AbstractOperation>)((CompositeOperation)op).getSubOperations());
                } else {
                    tmpList.add(op);
                }
                for (AbstractOperation ao : tmpList) {
                    if (!ao.equals(theirOperation)) continue;
                    LogMessage log = cp.getLogMessage();
                    if (log == null) {
                        return "";
                    }
                    return log.getAuthor() == null ? "" : log.getAuthor();
                }
            }
        }
        return "";
    }

    public Project getProject() {
        return this.project;
    }

    public ChangePackageVisualizationHelper getChangePackageVisualizationHelper() {
        if (this.visualizationHelper == null) {
            ArrayList<ChangePackage> list = new ArrayList<ChangePackage>();
            list.add(this.myChangePackage);
            list.addAll(this.theirChangePackages);
            this.visualizationHelper = new ChangePackageVisualizationHelper(list, this.project);
        }
        return this.visualizationHelper;
    }

    public PrimaryVersionSpec getBaseVersion() {
        return this.baseVersion;
    }

    public PrimaryVersionSpec getTargetVersion() {
        return this.targetVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Conflicting {
        private ArrayList<AbstractOperation> myOps = new ArrayList();
        private ArrayList<AbstractOperation> theirOps;

        public Conflicting(AbstractOperation myOp, AbstractOperation theirOp) {
            this.myOps.add(myOp);
            this.theirOps = new ArrayList();
            this.theirOps.add(theirOp);
        }

        public AbstractOperation getTheirOperation() {
            return this.theirOps.get(0);
        }

        public AbstractOperation getMyOperation() {
            return this.myOps.get(0);
        }

        public List<AbstractOperation> getTheirOperations() {
            return this.theirOps;
        }

        public List<AbstractOperation> getMyOperations() {
            return this.myOps;
        }

        public boolean add(AbstractOperation myOp, AbstractOperation theirOp) {
            for (AbstractOperation ao : this.getTheirOperations()) {
                if (!DecisionManager.this.conflictDetector.doConflict(myOp, ao)) continue;
                this.addToList(myOp, theirOp);
                return true;
            }
            for (AbstractOperation ao : this.getMyOperations()) {
                if (!DecisionManager.this.conflictDetector.doConflict(ao, theirOp)) continue;
                this.addToList(myOp, theirOp);
                return true;
            }
            return false;
        }

        private void addToList(AbstractOperation my, AbstractOperation their) {
            this.addMyOp(my);
            this.addTheirOp(their);
        }

        private void addMyOp(AbstractOperation my) {
            if (!this.myOps.contains(my)) {
                this.myOps.add(my);
            }
        }

        private void addTheirOp(AbstractOperation their) {
            if (!this.theirOps.contains(their)) {
                this.theirOps.add(their);
            }
        }

        public void addMyOps(List<AbstractOperation> ops) {
            for (AbstractOperation ao : ops) {
                this.addMyOp(ao);
            }
        }

        public void addTheirOps(List<AbstractOperation> ops) {
            for (AbstractOperation ao : ops) {
                this.addTheirOp(ao);
            }
        }
    }
}

