/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.common.commands.DeleteModelElementCommand;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.utilities.ShortLabelProvider;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.AnnotationHiddenDescriptor;
import org.eclipse.emf.ecp.editor.AnnotationPositionDescriptor;
import org.eclipse.emf.ecp.editor.AnnotationPriorityDescriptor;
import org.eclipse.emf.ecp.editor.ControlFactory;
import org.eclipse.emf.ecp.editor.MEEditor;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.FeatureHintTooltipSupport;
import org.eclipse.emf.ecp.editor.mecontrols.IValidatableControl;
import org.eclipse.emf.ecp.editor.mecontrols.METextControl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IEvaluationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEEditorPage
extends FormPage {
    private EObject modelElement;
    private FormToolkit toolkit;
    private Map<EStructuralFeature, AbstractMEControl> meControls = new HashMap<EStructuralFeature, AbstractMEControl>();
    private Map<AbstractMEControl, Diagnostic> valdiatedControls = new HashMap<AbstractMEControl, Diagnostic>();
    private static String activeModelelement = "activeModelelement";
    private ScrolledForm form;
    private List<IItemPropertyDescriptor> leftColumnAttributes = new ArrayList<IItemPropertyDescriptor>();
    private List<IItemPropertyDescriptor> rightColumnAttributes = new ArrayList<IItemPropertyDescriptor>();
    private List<IItemPropertyDescriptor> bottomAttributes = new ArrayList<IItemPropertyDescriptor>();
    private Composite leftColumnComposite;
    private Composite rightColumnComposite;
    private Composite bottomComposite;
    private EStructuralFeature problemFeature;
    private final ECPModelelementContext modelElementContext;
    private final ComposedAdapterFactory adapterFactory;

    public MEEditorPage(MEEditor editor, String id, String title, ECPModelelementContext modelElementContext, EObject modelElement) {
        super((FormEditor)editor, id, title);
        this.modelElementContext = modelElementContext;
        this.modelElement = modelElement;
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    public MEEditorPage(MEEditor editor, String id, String title, ECPModelelementContext modelElementContext, EObject modelElement, EStructuralFeature problemFeature) {
        this(editor, id, title, modelElementContext, modelElement);
        this.problemFeature = problemFeature;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.toolkit = this.getEditor().getToolkit();
        this.form = managedForm.getForm();
        this.toolkit.decorateFormHeading(this.form.getForm());
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        Composite topComposite = this.toolkit.createComposite(body);
        topComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topComposite);
        this.sortAndOrderAttributes();
        if (!this.rightColumnAttributes.isEmpty()) {
            SashForm topSash = new SashForm(topComposite, 256);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topSash);
            this.toolkit.adapt((Control)topSash, true, true);
            topSash.setSashWidth(4);
            this.leftColumnComposite = this.toolkit.createComposite((Composite)topSash, 0);
            this.rightColumnComposite = this.toolkit.createComposite((Composite)topSash, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(5, 2, 5, 5).applyTo(this.rightColumnComposite);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.rightColumnComposite);
            int[] topWeights = new int[]{50, 50};
            topSash.setWeights(topWeights);
        } else {
            this.leftColumnComposite = this.toolkit.createComposite(topComposite, 0);
        }
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(2, 5, 5, 5).applyTo(this.leftColumnComposite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.leftColumnComposite);
        this.bottomComposite = this.toolkit.createComposite(topComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(0, 0, 0, 0).applyTo(this.bottomComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.bottomComposite);
        this.form.setImage(new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory).getImage((Object)this.modelElement));
        this.createAttributes(this.leftColumnComposite, this.leftColumnAttributes);
        if (!this.rightColumnAttributes.isEmpty()) {
            this.createAttributes(this.rightColumnComposite, this.rightColumnAttributes);
        }
        this.createAttributes(this.bottomComposite, this.bottomAttributes);
        this.createToolbar();
        this.form.pack();
        this.updateSectionTitle();
        this.updateLiveValidation();
    }

    public void updateSectionTitle() {
        ShortLabelProvider shortLabelProvider = new ShortLabelProvider();
        String name = shortLabelProvider.getText((Object)this.modelElement);
        name = String.valueOf(name) + " [" + this.modelElement.eClass().getName() + "]";
        try {
            this.form.setText(name);
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    private void createToolbar() {
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        AbstractSourceProvider sourceProvider = new AbstractSourceProvider(){

            public void dispose() {
            }

            public Map getCurrentState() {
                HashMap<String, EObject> map = new HashMap<String, EObject>();
                map.put(activeModelelement, MEEditorPage.this.modelElement);
                return map;
            }

            public String[] getProvidedSourceNames() {
                String[] namens = new String[]{activeModelelement};
                return namens;
            }
        };
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        service.addSourceProvider((ISourceProvider)sourceProvider);
        this.form.getToolBarManager().add((IAction)new Action("", Activator.getImageDescriptor("icons/delete.gif")){

            public void run() {
                new DeleteModelElementCommand(MEEditorPage.this.modelElement, MEEditorPage.this.modelElementContext).run();
            }
        });
        menuService.populateContributionManager((ContributionManager)this.form.getToolBarManager(), "toolbar:org.eclipse.emf.ecp.editor.MEEditorPage");
        this.form.getToolBarManager().update(true);
    }

    private void filterHiddenAttributes(Collection<IItemPropertyDescriptor> propertyDescriptors) {
        Iterator<IItemPropertyDescriptor> iterator = propertyDescriptors.iterator();
        AnnotationHiddenDescriptor visibilityDescriptor = new AnnotationHiddenDescriptor();
        while (iterator.hasNext()) {
            IItemPropertyDescriptor descriptor = iterator.next();
            if (!visibilityDescriptor.getValue(descriptor, this.modelElement).booleanValue()) continue;
            iterator.remove();
        }
    }

    private void sortAndOrderAttributes() {
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory);
        List propertyDescriptors = adapterFactoryItemDelegator.getPropertyDescriptors((Object)this.modelElement);
        this.filterHiddenAttributes(propertyDescriptors);
        if (propertyDescriptors != null) {
            AnnotationPositionDescriptor positionDescriptor = new AnnotationPositionDescriptor();
            for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDescriptors) {
                String value = positionDescriptor.getValue(itemPropertyDescriptor, this.modelElement);
                if (value.equals("left")) {
                    this.leftColumnAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                if (value.equals("right")) {
                    this.rightColumnAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                if (value.equals("bottom")) {
                    this.bottomAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                this.leftColumnAttributes.add(itemPropertyDescriptor);
            }
            final HashMap<IItemPropertyDescriptor, Double> priorityMap = new HashMap<IItemPropertyDescriptor, Double>();
            AnnotationPriorityDescriptor priorityDescriptor = new AnnotationPriorityDescriptor();
            for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDescriptors) {
                priorityMap.put(itemPropertyDescriptor, priorityDescriptor.getValue(itemPropertyDescriptor, this.modelElement));
            }
            Comparator<IItemPropertyDescriptor> comparator = new Comparator<IItemPropertyDescriptor>(){

                @Override
                public int compare(IItemPropertyDescriptor o1, IItemPropertyDescriptor o2) {
                    return Double.compare((Double)priorityMap.get(o1), (Double)priorityMap.get(o2));
                }
            };
            Collections.sort(this.leftColumnAttributes, comparator);
            Collections.sort(this.rightColumnAttributes, comparator);
            Collections.sort(this.bottomAttributes, comparator);
        }
    }

    private void createAttributes(Composite column, List<IItemPropertyDescriptor> attributes) {
        Composite attributeComposite = this.toolkit.createComposite(column);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(attributeComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 1).indent(10, 0).applyTo((Control)attributeComposite);
        ControlFactory controlFactory = new ControlFactory();
        for (IItemPropertyDescriptor itemPropertyDescriptor : attributes) {
            Control control;
            AbstractMEControl meControl = controlFactory.createControl(itemPropertyDescriptor, this.modelElement, this.modelElementContext);
            if (meControl == null) continue;
            this.meControls.put((EStructuralFeature)itemPropertyDescriptor.getFeature((Object)this.modelElement), meControl);
            if (meControl.getShowLabel()) {
                Label label = this.toolkit.createLabel(attributeComposite, itemPropertyDescriptor.getDisplayName((Object)this.modelElement));
                label.setData((Object)this.modelElement);
                FeatureHintTooltipSupport.enableFor((Control)label, itemPropertyDescriptor);
                control = meControl.createControl(attributeComposite, 64, itemPropertyDescriptor, this.modelElement, this.modelElementContext, this.toolkit);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
                GridDataFactory.fillDefaults().grab(true, false).align(4, 1).indent(10, 0).applyTo(control);
                meControl.applyCustomLayoutData();
            } else {
                control = meControl.createControl(attributeComposite, 64, itemPropertyDescriptor, this.modelElement, this.modelElementContext, this.toolkit);
                control.setData((Object)this.modelElement);
                FeatureHintTooltipSupport.enableFor(control, itemPropertyDescriptor);
                GridDataFactory.fillDefaults().span(2, 1).grab(true, true).align(4, 1).indent(10, 0).applyTo(control);
            }
            if (itemPropertyDescriptor.getFeature((Object)this.modelElement) != this.problemFeature) continue;
            ControlDecoration dec = new ControlDecoration(control, 16512);
            dec.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            dec.setDescriptionText("Problem detected.");
        }
    }

    public void dispose() {
        for (AbstractMEControl control : this.meControls.values()) {
            control.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        for (AbstractMEControl meControl : this.meControls.values()) {
            if (!(meControl instanceof METextControl)) continue;
            ((METextControl)meControl).setFocus();
            return;
        }
        this.leftColumnComposite.setFocus();
    }

    public void updateLiveValidation() {
        AbstractMEControl meControl;
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(this.modelElement);
        ArrayList<AbstractMEControl> affectedControls = new ArrayList<AbstractMEControl>();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            EObject eObject;
            Object object = childDiagnostic.getData().get(0);
            if (object instanceof EObject && (eObject = (EObject)object) != this.modelElement) continue;
            meControl = this.meControls.get(childDiagnostic.getData().get(1));
            affectedControls.add(meControl);
            if (!(meControl instanceof IValidatableControl)) continue;
            if (this.valdiatedControls.containsKey(meControl)) {
                if (childDiagnostic.getSeverity() == this.valdiatedControls.get(meControl).getSeverity()) continue;
                ((IValidatableControl)((Object)meControl)).handleValidation(childDiagnostic);
                this.valdiatedControls.put(meControl, childDiagnostic);
                continue;
            }
            ((IValidatableControl)((Object)meControl)).handleValidation(childDiagnostic);
            this.valdiatedControls.put(meControl, childDiagnostic);
        }
        HashMap<AbstractMEControl, Diagnostic> temp = new HashMap<AbstractMEControl, Diagnostic>();
        temp.putAll(this.valdiatedControls);
        for (Map.Entry entry : temp.entrySet()) {
            meControl = (AbstractMEControl)entry.getKey();
            if (affectedControls.contains(meControl)) continue;
            this.valdiatedControls.remove(meControl);
            ((IValidatableControl)((Object)meControl)).resetValidation();
        }
    }
}

