/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MEPrimitiveAttributeControl<T>
extends AbstractMEControl {
    public static final Map<Class<?>, Class<?>> primitives = new HashMap();
    private Text text;
    private boolean doVerify;
    private EAttribute attribute;
    private Composite composite;
    private Label labelWidgetImage;
    private ControlDecoration controlDecoration;
    private EMFDataBindingContext dbc;

    static {
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Short.class, Short.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Double.class, Double.TYPE);
    }

    protected abstract int getPriority();

    protected abstract T convertStringToModel(String var1);

    protected abstract String convertModelToString(T var1);

    protected abstract T getDefaultValue();

    protected abstract void postValidate(String var1);

    protected abstract boolean validateString(String var1);

    @Override
    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EAttribute && (((EAttribute)feature).getEType().getInstanceClass().equals(primitives.get(this.getClassType())) || ((EAttribute)feature).getEType().getInstanceClass().equals(this.getClassType())) && !((EAttribute)feature).isMany()) {
            return this.getPriority();
        }
        return -1;
    }

    protected void setUnvalidatedString(String string) {
        this.doVerify = false;
        this.text.setText(string);
        this.doVerify = true;
    }

    private Class<T> getClassType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    protected Control createControl(Composite parent, int style) {
        this.doVerify = true;
        Object feature = this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.attribute = (EAttribute)feature;
        this.composite = this.getToolkit().createComposite(parent, style);
        this.composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.composite);
        this.labelWidgetImage = this.getToolkit().createLabel(this.composite, "    ");
        this.labelWidgetImage.setBackground(parent.getBackground());
        this.text = this.getToolkit().createText(this.composite, new String(), style | 4 | 0x800);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement())) {
            this.text.setEditable(false);
        }
        this.controlDecoration = new ControlDecoration((Control)this.text, 131200);
        this.controlDecoration.setDescriptionText("Invalid input");
        this.controlDecoration.setShowHover(true);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.controlDecoration.setImage(fieldDecoration.getImage());
        IObservableValue model = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(), (EObject)this.getModelElement(), (EStructuralFeature)this.attribute);
        this.dbc = new EMFDataBindingContext();
        ISWTObservableValue observeText = SWTObservables.observeText((Control)this.text, (int)16);
        this.dbc.bindValue((IObservableValue)observeText, model, this.getTargetToModelStrategy(), this.getModelToTargetStrategy());
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (MEPrimitiveAttributeControl.this.doVerify && !MEPrimitiveAttributeControl.this.validateString(String.valueOf(MEPrimitiveAttributeControl.this.text.getText()) + e.text)) {
                    e.doit = false;
                    return;
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (MEPrimitiveAttributeControl.this.text.getText().equals("")) {
                    MEPrimitiveAttributeControl.this.setUnvalidatedString(MEPrimitiveAttributeControl.this.convertModelToString(MEPrimitiveAttributeControl.this.getDefaultValue()));
                } else {
                    MEPrimitiveAttributeControl.this.postValidate(MEPrimitiveAttributeControl.this.text.getText());
                }
                MEPrimitiveAttributeControl.this.dbc.updateModels();
                MEPrimitiveAttributeControl.this.dbc.updateTargets();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        return this.composite;
    }

    protected UpdateValueStrategy getTargetToModelStrategy() {
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                boolean valid = MEPrimitiveAttributeControl.this.validateString(MEPrimitiveAttributeControl.this.text.getText());
                if (valid) {
                    MEPrimitiveAttributeControl.this.controlDecoration.hide();
                    return ValidationStatus.ok();
                }
                MEPrimitiveAttributeControl.this.controlDecoration.show();
                return ValidationStatus.error((String)"Not a double.");
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        strategy.setAfterGetValidator(validator);
        strategy.setConverter(this.getConverter());
        return strategy;
    }

    protected UpdateValueStrategy getModelToTargetStrategy() {
        UpdateValueStrategy updateValueStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        updateValueStrategy.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return MEPrimitiveAttributeControl.this.getClassType();
            }

            public Object convert(Object fromObject) {
                Object val = fromObject;
                return MEPrimitiveAttributeControl.this.convertModelToString(val);
            }
        });
        return updateValueStrategy;
    }

    @Override
    public void applyCustomLayoutData() {
        GridDataFactory.fillDefaults().grab(true, false).hint(250, 16).align(4, 128).applyTo((Control)this.text);
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImageDescriptor("icons/validation_error.png").createImage();
            this.labelWidgetImage.setImage(image);
            this.labelWidgetImage.setToolTipText(diagnostic.getMessage());
        }
    }

    public void resetValidation() {
        this.labelWidgetImage.setImage(null);
        this.labelWidgetImage.setToolTipText("");
    }

    public void setFocus() {
        this.text.setFocus();
    }

    protected IConverter getConverter() {
        IConverter converter = new IConverter(){

            public Object getToType() {
                return MEPrimitiveAttributeControl.this.getClassType();
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                Object convertedValue = MEPrimitiveAttributeControl.this.convertStringToModel((String)fromObject);
                return convertedValue;
            }
        };
        return converter;
    }
}

