/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.SimpleFMCTypeChecker;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class ExtensibleFMCTypeChecker
implements FMCTypeChecker {
    private List<FMCTypeChecker> helpers = new ArrayList<FMCTypeChecker>();

    public ExtensibleFMCTypeChecker() {
        this.helpers.add(new SimpleFMCTypeChecker());
        this.addTypeCheckersFromExtensionPoint();
    }

    @Override
    public boolean isFMCNode(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isFMCNode(element);
        }
        return check;
    }

    @Override
    public boolean isFMCConnection(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isFMCConnection(element);
        }
        return check;
    }

    @Override
    public boolean isAgent(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isAgent(element);
        }
        return check;
    }

    @Override
    public boolean isHumanAgent(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isHumanAgent(element);
        }
        return check;
    }

    @Override
    public boolean isStorage(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isStorage(element);
        }
        return check;
    }

    @Override
    public boolean isStructureVariance(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isStructureVariance(element);
        }
        return check;
    }

    @Override
    public boolean isCommunicationChannel(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isCommunicationChannel(element);
        }
        return check;
    }

    @Override
    public boolean isChannelType(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isChannelType(element);
        }
        return check;
    }

    @Override
    public boolean isAccessType(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isAccessType(element);
        }
        return check;
    }

    @Override
    public boolean isChannelType(Object obj) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isChannelType(obj);
        }
        return check;
    }

    @Override
    public boolean isReqRespCommunicationChannel(Object obj) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isReqRespCommunicationChannel(obj);
        }
        return check;
    }

    @Override
    public boolean isUnidirectionalCommunicationChannel(Object obj) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isUnidirectionalCommunicationChannel(obj);
        }
        return check;
    }

    @Override
    public boolean isReqRespCommunicationChannel(Connection con) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isReqRespCommunicationChannel(con);
        }
        return check;
    }

    private void addTypeCheckersFromExtensionPoint() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor("org.eclipse.fmc.blockdiagram.editor.typechecking");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                FMCTypeChecker helper = (FMCTypeChecker)element.createExecutableExtension("class");
                if (!this.containsType(this.helpers, helper.getClass())) {
                    this.helpers.add(helper);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private boolean containsType(Collection<?> col, Class<?> type) {
        for (Object object : col) {
            if (!type.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModifyAccess(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isModifyAccess(element);
        }
        return check;
    }

    @Override
    public boolean isBrace(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isBrace(element);
        }
        return check;
    }

    @Override
    public boolean isAreaBorder(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isAreaBorder(element);
        }
        return check;
    }

    @Override
    public boolean isDots(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isDots(element);
        }
        return check;
    }

    @Override
    public boolean isTextComment(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isTextComment(element);
        }
        return check;
    }

    @Override
    public boolean isComment(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isComment(element);
        }
        return check;
    }

    @Override
    public boolean isImage(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isImage(element);
        }
        return check;
    }

    @Override
    public boolean isCommonFeatureArea(PictogramElement element) {
        boolean check = false;
        Iterator<FMCTypeChecker> iterator = this.helpers.iterator();
        while (!check && iterator.hasNext()) {
            FMCTypeChecker helper = iterator.next();
            check = helper.isCommonFeatureArea(element);
        }
        return check;
    }
}

