/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommentType implements Enumerator
{
    TEXT(0, "TEXT", "TEXT"),
    IMAGE(1, "IMAGE", "IMAGE"),
    OTHER(2, "OTHER", "OTHER"),
    BRACE(3, "BRACE", "BRACE"),
    AREABORDER(4, "AREABORDER", "AREABORDER"),
    COMMONFEATUREAREA(5, "COMMONFEATUREAREA", "COMMONFEATUREAREA"),
    DOTS(6, "DOTS", "DOTS");

    public static final int TEXT_VALUE = 0;
    public static final int IMAGE_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    public static final int BRACE_VALUE = 3;
    public static final int AREABORDER_VALUE = 4;
    public static final int COMMONFEATUREAREA_VALUE = 5;
    public static final int DOTS_VALUE = 6;
    private static final CommentType[] VALUES_ARRAY;
    public static final List<CommentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommentType[]{TEXT, IMAGE, OTHER, BRACE, AREABORDER, COMMONFEATUREAREA, DOTS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommentType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return IMAGE;
            }
            case 2: {
                return OTHER;
            }
            case 3: {
                return BRACE;
            }
            case 4: {
                return AREABORDER;
            }
            case 5: {
                return COMMONFEATUREAREA;
            }
            case 6: {
                return DOTS;
            }
        }
        return null;
    }

    private CommentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

