/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fmc.blockdiagram.editor.features.CompositeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.CommunicationChannelAddFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.BlockDiagramMetaFeatureProvider;
import org.eclipse.fmc.blockdiagram.editor.meta.features.add.AccessAddMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.Access;
import org.eclipse.fmc.mm.AccessType;
import org.eclipse.fmc.mm.Agent;
import org.eclipse.fmc.mm.Channel;
import org.eclipse.fmc.mm.Storage;
import org.eclipse.fmc.mm.impl.AgentImpl;
import org.eclipse.fmc.mm.impl.StorageImpl;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class AddConnectionHelper {
    CompositeFeature cf = null;

    public void addAgentConnections(PictogramElement picEl, BlockDiagramMetaFeatureProvider fmcFP, Diagram diargam) {
        HashMap<EObject, List<PictogramElement>> diagramEObj = new HashMap<EObject, List<PictogramElement>>();
        this.GetAllEObjectOfDiagram((ContainerShape)diargam, diagramEObj);
        AgentImpl agent = (AgentImpl)FMCUtil.getBO((PictogramElement)picEl);
        if (agent.getAccessConnections().size() == 0 && agent.getSourceChannels().size() == 0 && agent.getTargetChannels().size() == 0) {
            return;
        }
        ArrayList<Object> cFList = new ArrayList<Object>();
        List<Channel> sourceChanels = this.getSourceChanels((Agent)agent, diagramEObj);
        for (Channel chl : sourceChanels) {
            for (PictogramElement pe : diagramEObj.get(chl.getTarget())) {
                AddConnectionContext context = this.createContext(picEl, pe, chl, ConnectionStyle.MANHATTAN);
                CommunicationChannelAddFeature addFeature = (CommunicationChannelAddFeature)fmcFP.getAddFeature((IAddContext)context);
                addFeature.execute((IContext)context);
                cFList.add(addFeature);
            }
        }
        List<Channel> targetChanels = this.getTargetChanels((Agent)agent, diagramEObj);
        for (Channel chl : targetChanels) {
            for (PictogramElement pe : diagramEObj.get(chl.getSource())) {
                AddConnectionContext context = this.createContext(pe, picEl, chl, ConnectionStyle.MANHATTAN);
                CommunicationChannelAddFeature addFeature = (CommunicationChannelAddFeature)fmcFP.getAddFeature((IAddContext)context);
                addFeature.execute((IContext)context);
                cFList.add(addFeature);
            }
        }
        List<Access> storageConn = this.getStorageConnections((Agent)agent, diagramEObj);
        for (Access access : storageConn) {
            for (PictogramElement pe : diagramEObj.get(access.getTarget())) {
                AddConnectionContext context = null;
                context = access.getType() == AccessType.READ ? this.createContext(pe, picEl, access, ConnectionStyle.MANHATTAN) : (access.getType() == AccessType.WRITE ? this.createContext(picEl, pe, access, ConnectionStyle.MANHATTAN) : this.createContext(picEl, pe, access, ConnectionStyle.COMPOSITE));
                AccessAddMetaFeature addFeature = (AccessAddMetaFeature)fmcFP.getAddFeature((IAddContext)context);
                addFeature.execute((IContext)context);
                cFList.add((Object)addFeature);
            }
        }
        IFeature[] featureList = new IFeature[cFList.size()];
        this.cf = new CompositeFeature(cFList.toArray(featureList));
    }

    public void addStorageConnections(PictogramElement picEl, BlockDiagramMetaFeatureProvider fmcFP, Diagram diargam) {
        HashMap<EObject, List<PictogramElement>> diagramEObj = new HashMap<EObject, List<PictogramElement>>();
        this.GetAllEObjectOfDiagram((ContainerShape)diargam, diagramEObj);
        StorageImpl storage = (StorageImpl)FMCUtil.getBO((PictogramElement)picEl);
        if (storage.getConnections().size() == 0) {
            return;
        }
        ArrayList<AccessAddMetaFeature> cFList = new ArrayList<AccessAddMetaFeature>();
        List<Access> storageConn = this.getStorageConnections((Storage)storage, diagramEObj);
        for (Access access : storageConn) {
            for (PictogramElement pe : diagramEObj.get(access.getAgent())) {
                AddConnectionContext context = null;
                context = access.getType() == AccessType.READ ? this.createContext(picEl, pe, access, ConnectionStyle.MANHATTAN) : (access.getType() == AccessType.WRITE ? this.createContext(pe, picEl, access, ConnectionStyle.MANHATTAN) : this.createContext(pe, picEl, access, ConnectionStyle.COMPOSITE));
                AccessAddMetaFeature addFeature = (AccessAddMetaFeature)fmcFP.getAddFeature((IAddContext)context);
                addFeature.execute((IContext)context);
                cFList.add(addFeature);
            }
        }
        IFeature[] featureList = new IFeature[cFList.size()];
        this.cf = new CompositeFeature(cFList.toArray(featureList));
    }

    private void GetAllEObjectOfDiagram(ContainerShape cShape, Map<EObject, List<PictogramElement>> map) {
        for (Shape shape : cShape.getChildren()) {
            if (shape instanceof ContainerShape) {
                this.GetAllEObjectOfDiagram((ContainerShape)shape, map);
            }
            if (!shape.isActive()) continue;
            EObject obj = FMCUtil.getBO((PictogramElement)shape);
            if (map.containsKey(obj)) {
                map.get(obj).add((PictogramElement)shape);
                continue;
            }
            ArrayList<Shape> lst = new ArrayList<Shape>();
            lst.add(shape);
            map.put(obj, lst);
        }
    }

    private List<Access> getStorageConnections(Storage storage, Map<EObject, List<PictogramElement>> diagramEObj) {
        ArrayList<Access> returnList = new ArrayList<Access>();
        for (Access access : storage.getConnections()) {
            if (!diagramEObj.containsKey(access.getAgent())) continue;
            returnList.add(access);
        }
        return returnList;
    }

    private List<Access> getStorageConnections(Agent agent, Map<EObject, List<PictogramElement>> diagramEObj) {
        ArrayList<Access> returnList = new ArrayList<Access>();
        for (Access access : agent.getAccessConnections()) {
            if (!diagramEObj.containsKey(access.getTarget())) continue;
            returnList.add(access);
        }
        return returnList;
    }

    private List<Channel> getSourceChanels(Agent agent, Map<EObject, List<PictogramElement>> diagramEObj) {
        ArrayList<Channel> returnList = new ArrayList<Channel>();
        for (Channel chl : agent.getSourceChannels()) {
            if (!diagramEObj.containsKey(chl.getTarget())) continue;
            returnList.add(chl);
        }
        return returnList;
    }

    private List<Channel> getTargetChanels(Agent agent, Map<EObject, List<PictogramElement>> diagramEObj) {
        ArrayList<Channel> returnList = new ArrayList<Channel>();
        for (Channel chl : agent.getTargetChannels()) {
            if (!diagramEObj.containsKey(chl.getSource())) continue;
            returnList.add(chl);
        }
        return returnList;
    }

    private Anchor getAnchor(PictogramElement pe) {
        Anchor ret = null;
        if (pe instanceof Anchor) {
            ret = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            ret = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        return ret;
    }

    private AddConnectionContext createContext(PictogramElement sourceObject, PictogramElement targetObject, Object obj, ConnectionStyle connStyle) {
        AddConnectionContext connectionContext = new AddConnectionContext(this.getAnchor(sourceObject), this.getAnchor(targetObject));
        connectionContext.setNewObject(obj);
        connectionContext.putProperty((Object)"graphicalType", (Object)connStyle);
        return connectionContext;
    }

    public boolean isAvailable(IContext context) {
        if (this.cf != null) {
            return this.cf.isAvailable(context);
        }
        return true;
    }

    public boolean canExecute(IContext context) {
        if (this.cf != null) {
            return this.cf.canExecute(context);
        }
        return true;
    }

    public void execute(IContext context) {
        if (this.cf != null) {
            this.cf.execute(context);
        }
    }

    public boolean canUndo(IContext context) {
        if (this.cf != null) {
            return this.cf.canUndo(context);
        }
        return true;
    }

    public boolean hasDoneChanges() {
        if (this.cf != null) {
            return this.cf.hasDoneChanges();
        }
        return true;
    }
}

