/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Messages {
    private static final boolean ANSI = !System.getProperty("os.name").contains("Windows");
    private static final boolean color = System.console() != null;
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("messages", Locale.getDefault());
    private static final String ERROR = "\u001b[31m";
    private static final String INFO = "\u001b[34m";
    private static final String WARNING = "\u001b[33m";
    private static final String STACK = "\u001b[36m";

    private Messages() {
    }

    private static boolean withColor() {
        return ANSI && color;
    }

    public static String message(String key, Object ... values) {
        return MessageFormat.format(MESSAGES.getString(key), values);
    }

    public static String message(String key) {
        return MESSAGES.getString(key);
    }

    public static String prefixed(String prefix, String message) {
        return Messages.prefixed(prefix, message, null);
    }

    public static String prefixed(String prefix, String message, String color) {
        if (!Messages.withColor() || color == null) {
            return String.format("[%s] %s", MESSAGES.getString(prefix), message);
        }
        return String.format("[%s%s\u001b[0m] %s", color, MESSAGES.getString(prefix), message);
    }

    public static void printPrefixed(String prefix, String message, String color) {
        System.err.println(Messages.prefixed(prefix, message, color));
    }

    public static void error(Object message, String prefix) {
        Messages.printPrefixed("error", prefix + String.valueOf(message), ERROR);
    }

    public static void error(Object message) {
        Messages.error(message, "");
    }

    public static void warning(Object message) {
        Messages.printPrefixed("warning", message.toString(), WARNING);
    }

    public static void info(Object message) {
        Messages.printPrefixed("info", message.toString(), INFO);
    }

    public static void printStackTrace(Throwable e) {
        if (Messages.withColor()) {
            System.err.print(STACK);
        }
        e.printStackTrace();
        if (Messages.withColor()) {
            System.err.println("\u001b[0m");
        }
    }
}

