/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.util.LinkedList;

public final class Observable {
    private volatile Object value;
    private final Object lock = new Object();
    private final LinkedList<Observer> observers = new LinkedList();

    public Observable(Object initialValue) {
        this.value = initialValue;
    }

    public Object get() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            this.value = newValue;
            for (Observer observer : this.observers) {
                observer.apply(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observable onChange(Observer observer) {
        Object object = this.lock;
        synchronized (object) {
            this.observers.add(observer);
        }
        return this;
    }

    public Observable filter(Predicate predicate) {
        Observable observable = new Observable(null);
        this.onChange(newValue -> {
            if (predicate.apply(newValue)) {
                observable.set(newValue);
            }
        });
        return observable;
    }

    public Observable map(Function function) {
        Observable observable = new Observable(null);
        this.onChange(newValue -> observable.set(function.apply(newValue)));
        return observable;
    }

    public String toString() {
        return String.format("Observable{value=%s}", this.value);
    }

    @FunctionalInterface
    public static interface Observer {
        public void apply(Object var1);
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean apply(Object var1);
    }

    @FunctionalInterface
    public static interface Function {
        public Object apply(Object var1);
    }
}

