/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Alternatives;
import gololang.ir.Block;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.WhenClause;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CaseStatement
extends GoloStatement<CaseStatement>
implements Alternatives<Block> {
    private Block otherwise;
    private final LinkedList<WhenClause<Block>> clauses = new LinkedList();

    private CaseStatement() {
    }

    public static CaseStatement cases() {
        return new CaseStatement();
    }

    @Override
    protected CaseStatement self() {
        return this;
    }

    public CaseStatement when(Object cond) {
        if (cond instanceof WhenClause) {
            WhenClause clause = (WhenClause)cond;
            this.clauses.add(this.makeParentOf(clause));
        } else {
            this.clauses.add(this.makeParentOf(new WhenClause<Object>(ExpressionStatement.of(cond), null)));
        }
        return this;
    }

    public CaseStatement then(Object action) {
        this.clauses.getLast().then(Block.of(action));
        return this;
    }

    public CaseStatement otherwise(Object action) {
        this.otherwise = this.makeParentOf(Block.of(action));
        return this;
    }

    @Override
    public List<WhenClause<Block>> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public Block getOtherwise() {
        return this.otherwise;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCaseStatement(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.clauses);
        children.add((WhenClause<Block>)((Object)this.otherwise));
        return children;
    }

    @Override
    public void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!(newElement instanceof Block) && !(newElement instanceof WhenClause)) {
            throw CaseStatement.cantConvert("Block or WhenClause", newElement);
        }
        if (this.otherwise.equals(original)) {
            this.otherwise(newElement);
            return;
        }
        if (this.clauses.contains(original)) {
            WhenClause when = (WhenClause)newElement;
            this.clauses.set(this.clauses.indexOf(original), this.makeParentOf(when));
            return;
        }
        throw this.doesNotContain(original);
    }
}

