/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Block;
import gololang.ir.CollectionLiteral;
import gololang.ir.ExpressionStatement;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.LoopStatement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CollectionComprehension
extends ExpressionStatement<CollectionComprehension> {
    private final CollectionLiteral.Type type;
    private ExpressionStatement<?> expression;
    private final List<GoloStatement<?>> loopBlocks = new LinkedList();

    private CollectionComprehension(CollectionLiteral.Type type) {
        this.type = type;
    }

    public static CollectionComprehension of(Object type) {
        return new CollectionComprehension(type instanceof CollectionLiteral.Type ? (CollectionLiteral.Type)((Object)type) : CollectionLiteral.Type.valueOf(type.toString()));
    }

    public static CollectionComprehension create(Object type, Object expression, Object ... loops) {
        CollectionComprehension c = CollectionComprehension.of(type).expression(expression);
        for (Object l : loops) {
            c.loop(l);
        }
        return c;
    }

    @Override
    protected CollectionComprehension self() {
        return this;
    }

    public CollectionComprehension expression(Object expression) {
        this.expression = this.makeParentOf(ExpressionStatement.of(expression));
        return this;
    }

    public CollectionComprehension loop(Object loop) {
        if (!(loop instanceof ForEachLoopStatement) && !(loop instanceof LoopStatement)) {
            throw new IllegalArgumentException("Loop expected, got a " + loop.getClass().getName());
        }
        this.loopBlocks.add(this.makeParentOf(GoloStatement.of(loop)));
        return this;
    }

    public ExpressionStatement<?> expression() {
        return this.expression;
    }

    public List<GoloStatement<?>> loops() {
        return Collections.unmodifiableList(this.loopBlocks);
    }

    public CollectionLiteral.Type getType() {
        return this.type;
    }

    public CollectionLiteral.Type getMutableType() {
        return CollectionLiteral.Type.tuple.equals((Object)this.type) || CollectionLiteral.Type.array.equals((Object)this.type) ? CollectionLiteral.Type.list : this.type;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCollectionComprehension(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList();
        children.add(this.expression);
        children.addAll(this.loopBlocks);
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (this.expression == original && newElement instanceof ExpressionStatement) {
            this.expression(newElement);
        } else if (newElement instanceof Block && this.loopBlocks.contains(original)) {
            this.loopBlocks.set(this.loopBlocks.indexOf(original), Block.of(newElement));
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

