/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.Messages;
import gololang.ir.FunctionContainer;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.NamedElement;
import gololang.ir.ToplevelGoloElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;

public final class NamedAugmentation
extends GoloElement<NamedAugmentation>
implements FunctionContainer,
ToplevelGoloElement,
NamedElement {
    private final PackageAndClass name;
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();

    private NamedAugmentation(PackageAndClass name) {
        this.name = name;
    }

    public static NamedAugmentation of(Object name) {
        return new NamedAugmentation(PackageAndClass.of(name));
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public PackageAndClass getPackageAndClass() {
        return this.name;
    }

    @Override
    protected NamedAugmentation self() {
        return this;
    }

    @Override
    public List<GoloFunction> getFunctions() {
        return new ArrayList<GoloFunction>(this.functions);
    }

    @Override
    public void addFunction(GoloFunction func) {
        if (func.getArity() == 0) {
            throw new IllegalArgumentException(Messages.message("augment_function_no_args", func.getName(), this.getPackageAndClass()));
        }
        this.functions.add(this.makeParentOf(func));
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public NamedAugmentation add(Object ... elts) {
        for (Object elt : elts) {
            this.addElement(elt);
        }
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitNamedAugmentation(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.functions);
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.functions.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.functions.remove(original);
        this.addElement(newElement);
    }
}

