/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.FunctionReference;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.Noop;
import gololang.ir.ToplevelGoloElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class ToplevelElements
extends GoloElement<ToplevelElements>
implements Iterable<GoloElement<?>> {
    private final LinkedHashSet<GoloElement<?>> elements = new LinkedHashSet();

    private ToplevelElements(GoloElement<?> ... elements) {
        for (GoloElement<?> e : elements) {
            this.add(e);
        }
    }

    public static ToplevelElements of(Object ... elements) {
        ToplevelElements tl = new ToplevelElements(new GoloElement[0]);
        for (Object e : elements) {
            tl.add(e);
        }
        return tl;
    }

    @Override
    protected ToplevelElements self() {
        return this;
    }

    public ToplevelElements add(Object element) {
        if (element instanceof ToplevelElements) {
            for (GoloElement<?> e : (ToplevelElements)element) {
                this.add(e);
            }
        } else if (element instanceof ToplevelGoloElement && !(element instanceof Noop)) {
            GoloElement elt = (GoloElement)element;
            this.elements.add(this.makeParentOf(elt));
        } else {
            throw new IllegalArgumentException(element.toString());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public ToplevelElements map(FunctionReference fun) throws Throwable {
        ToplevelElements res = new ToplevelElements(new GoloElement[0]);
        for (GoloElement<?> elt : this) {
            res.add(fun.invoke(elt));
        }
        return res;
    }

    @Override
    public Iterator<GoloElement<?>> iterator() {
        return this.elements.iterator();
    }

    @Override
    public List<GoloElement<?>> children() {
        return new ArrayList(this.elements);
    }

    @Override
    public void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.elements.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.elements.remove(original);
        this.add(newElement);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitToplevelElements(this);
    }
}

